/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.asn1;

import com.donjin.org.bouncycastle.asn1.ASN1Encodable;
import com.donjin.org.bouncycastle.asn1.ASN1EncodableVector;
import com.donjin.org.bouncycastle.asn1.ASN1OutputStream;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.ASN1SetParser;
import com.donjin.org.bouncycastle.asn1.ASN1TaggedObject;
import com.donjin.org.bouncycastle.asn1.BERSet;
import com.donjin.org.bouncycastle.asn1.BERTaggedObject;
import com.donjin.org.bouncycastle.asn1.DERNull;
import com.donjin.org.bouncycastle.asn1.DERSet;
import com.donjin.org.bouncycastle.asn1.DLSet;
import com.donjin.org.bouncycastle.util.Arrays;
import com.donjin.org.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    private Vector set = new Vector();
    private boolean isSorted = false;

    public static ASN1Set getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        if (obj instanceof ASN1SetParser) {
            return ASN1Set.getInstance(((ASN1SetParser)obj).toASN1Primitive());
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Set.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Set) {
            return (ASN1Set)primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)obj.getObject();
        }
        ASN1Primitive o = obj.getObject();
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSet(o);
            }
            return new DLSet(o);
        }
        if (o instanceof ASN1Set) {
            return (ASN1Set)o;
        }
        if (o instanceof ASN1Sequence) {
            ASN1Sequence s = (ASN1Sequence)o;
            if (obj instanceof BERTaggedObject) {
                return new BERSet(s.toArray());
            }
            return new DLSet(s.toArray());
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected ASN1Set() {
    }

    protected ASN1Set(ASN1Encodable obj) {
        this.set.addElement(obj);
    }

    protected ASN1Set(ASN1EncodableVector v, boolean doSort) {
        int i = 0;
        while (i != v.size()) {
            this.set.addElement(v.get(i));
            ++i;
        }
        if (doSort) {
            this.sort();
        }
    }

    protected ASN1Set(ASN1Encodable[] array, boolean doSort) {
        int i = 0;
        while (i != array.length) {
            this.set.addElement(array[i]);
            ++i;
        }
        if (doSort) {
            this.sort();
        }
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public ASN1Encodable getObjectAt(int index) {
        return (ASN1Encodable)this.set.elementAt(index);
    }

    public int size() {
        return this.set.size();
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] values = new ASN1Encodable[this.size()];
        int i = 0;
        while (i != this.size()) {
            values[i] = this.getObjectAt(i);
            ++i;
        }
        return values;
    }

    public ASN1SetParser parser() {
        final ASN1Set outer = this;
        return new ASN1SetParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Set.this.size();
            }

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable obj;
                if (this.index == this.max) {
                    return null;
                }
                if ((obj = ASN1Set.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return outer;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return outer;
            }
        };
    }

    @Override
    public int hashCode() {
        Enumeration e = this.getObjects();
        int hashCode = this.size();
        while (e.hasMoreElements()) {
            ASN1Encodable o = this.getNext(e);
            hashCode *= 17;
            hashCode ^= o.hashCode();
        }
        return hashCode;
    }

    @Override
    ASN1Primitive toDERObject() {
        if (this.isSorted) {
            DERSet derSet = new DERSet();
            derSet.set = this.set;
            return derSet;
        }
        Vector v = new Vector();
        int i = 0;
        while (i != this.set.size()) {
            v.addElement(this.set.elementAt(i));
            ++i;
        }
        DERSet derSet = new DERSet();
        derSet.set = v;
        derSet.sort();
        return derSet;
    }

    @Override
    ASN1Primitive toDLObject() {
        DLSet derSet = new DLSet();
        derSet.set = this.set;
        return derSet;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1Set)) {
            return false;
        }
        ASN1Set other = (ASN1Set)o;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            ASN1Primitive o2;
            ASN1Encodable obj1 = this.getNext(s1);
            ASN1Encodable obj2 = this.getNext(s2);
            ASN1Primitive o1 = obj1.toASN1Primitive();
            if (o1 == (o2 = obj2.toASN1Primitive()) || o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable getNext(Enumeration e) {
        ASN1Encodable encObj = (ASN1Encodable)e.nextElement();
        if (encObj == null) {
            return DERNull.INSTANCE;
        }
        return encObj;
    }

    private boolean lessThanOrEqual(byte[] a, byte[] b) {
        int len = Math.min(a.length, b.length);
        int i = 0;
        while (i != len) {
            if (a[i] != b[i]) {
                return (a[i] & 0xFF) < (b[i] & 0xFF);
            }
            ++i;
        }
        return len == a.length;
    }

    private byte[] getDEREncoded(ASN1Encodable obj) {
        try {
            return obj.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    protected void sort() {
        if (!this.isSorted) {
            this.isSorted = true;
            if (this.set.size() > 1) {
                boolean swapped = true;
                int lastSwap = this.set.size() - 1;
                while (swapped) {
                    int index = 0;
                    int swapIndex = 0;
                    byte[] a = this.getDEREncoded((ASN1Encodable)this.set.elementAt(0));
                    swapped = false;
                    while (index != lastSwap) {
                        byte[] b = this.getDEREncoded((ASN1Encodable)this.set.elementAt(index + 1));
                        if (this.lessThanOrEqual(a, b)) {
                            a = b;
                        } else {
                            Object o = this.set.elementAt(index);
                            this.set.setElementAt(this.set.elementAt(index + 1), index);
                            this.set.setElementAt(o, index + 1);
                            swapped = true;
                            swapIndex = index;
                        }
                        ++index;
                    }
                    lastSwap = swapIndex;
                }
            }
        }
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.set.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }
}

