/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.BindValue;
import com.dolphindb.jdbc.ColumnBindValue;
import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSet;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.TypeCast;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JDBCPrepareStatement
extends JDBCStatement
implements PreparedStatement {
    private String preProcessedSql;
    private String tableName;
    private final int sqlDmlType;
    private List<ColumnBindValue> columnBindValues;
    private Map<Integer, Integer> insertIndexSQLToDDB;
    private BindValue[] bufferArea;
    private int batchSize = 0;
    private List<String> sqlBuffer;
    private boolean isPreparedStatement;

    public JDBCPrepareStatement(JDBCConnection conn, String sql) throws SQLException {
        super(conn);
        this.connection = conn;
        this.preProcessedSql = this.preProcessSql(sql, conn);
        String[] sqlSplit = this.preProcessedSql.split(";");
        String lastStatement = sqlSplit.length == 0 ? "" : sqlSplit[sqlSplit.length - 1].trim();
        this.sqlDmlType = Utils.getDml(lastStatement);
        this.sqlBuffer = new ArrayList<String>();
        this.insertIndexSQLToDDB = new HashMap<Integer, Integer>();
        if (this.preProcessedSql.contains("?")) {
            this.isPreparedStatement = true;
        }
        if (this.isPreparedStatement) {
            if (this.sqlDmlType == 1) {
                if (sqlSplit.length != 1) {
                    throw new SQLException("The INSERT statement must be a standalone statement.");
                }
                this.tableName = Utils.getTableName(this.preProcessedSql, this.isPreparedStatement);
                this.initColumnBindValues(this.tableName);
                Utils.checkInsertSQLValid(this.preProcessedSql, this.columnBindValues.size());
                Map<String, Integer> columnParamInSql = Utils.getInsertColumnParamInSql(this.preProcessedSql);
                Iterator<Object> iterator = this.columnBindValues.iterator();
                while (iterator.hasNext()) {
                    ColumnBindValue value = iterator.next();
                    String colName = value.getColName();
                    if (!columnParamInSql.containsKey(colName)) continue;
                    this.insertIndexSQLToDDB.put(columnParamInSql.get(colName), value.getIndex());
                    columnParamInSql.remove(colName);
                }
                if (columnParamInSql.size() != 0 && (iterator = columnParamInSql.keySet().iterator()).hasNext()) {
                    String key = (String)iterator.next();
                    throw new SQLException("The column name " + key + " does not exist in table. ");
                }
                this.bufferArea = new BindValue[this.columnBindValues.size()];
            } else {
                int size = 0;
                for (int i = 0; i < this.preProcessedSql.length(); ++i) {
                    char ch = this.preProcessedSql.charAt(i);
                    if (ch != '?') continue;
                    ++size;
                }
                this.bufferArea = new BindValue[size];
            }
        } else {
            this.sqlBuffer.add(this.preProcessedSql);
        }
    }

    private void initColumnBindValues(String tableName) throws SQLException {
        try {
            this.columnBindValues = new ArrayList<ColumnBindValue>();
            BasicDictionary schema = (BasicDictionary)this.connection.run(String.format("schema(%s)", tableName));
            BasicTable colDefs = (BasicTable)schema.get((Scalar)new BasicString("colDefs"));
            AbstractVector names = (AbstractVector)colDefs.getColumn("name");
            BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
            BasicIntVector extraInt = (BasicIntVector)colDefs.getColumn("extra");
            for (int i = 0; i < names.rows(); ++i) {
                String colName = names.getString(i).toLowerCase();
                int typeInt = colDefsTypeInt.getInt(i);
                Entity.DATA_TYPE type = Entity.DATA_TYPE.valueOf((int)typeInt);
                int extra = extraInt.getInt(i);
                ColumnBindValue columnBindValue = new ColumnBindValue(i, colName, type, extra);
                this.columnBindValues.add(columnBindValue);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchSize = 0;
        if (this.sqlBuffer != null) {
            this.sqlBuffer.clear();
        }
        if (this.columnBindValues != null) {
            this.columnBindValues.forEach(ColumnBindValue::clear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] executeRes = new int[this.batchSize];
        try {
            if (this.sqlDmlType == 1) {
                int[] nArray = this.tableAppend(true);
                return nArray;
            }
            for (int i = 0; i < this.batchSize; ++i) {
                try {
                    executeRes[i] = super.executeUpdate(this.sqlBuffer.get(i));
                    continue;
                }
                catch (Exception e) {
                    throw new BatchUpdateException(e.getMessage(), Arrays.copyOf(executeRes, i));
                }
            }
        }
        finally {
            this.clearBatch();
        }
        return executeRes;
    }

    private void bind(int paramIndex, Object obj) throws SQLException {
        if (this.sqlDmlType == 1) {
            int index = this.getDataIndexBySQLIndex(paramIndex);
            if (index >= this.columnBindValues.size()) {
                throw new SQLException("The index of columnBindValues is out of range.");
            }
            Vector column = this.columnBindValues.get(index).getBindValues();
            try {
                Entity data = BasicEntityFactory.createScalar((Entity.DATA_TYPE)column.getDataType(), (Object)obj, (int)this.columnBindValues.get(index).getScale());
                if (data.isScalar()) {
                    column.Append((Scalar)data);
                }
                column.Append((Vector)data);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            this.bufferArea[paramIndex - 1] = new BindValue(obj, false);
        }
    }

    private int getDataIndexBySQLIndex(int paramIndex) throws SQLException {
        int index = paramIndex - 1;
        if (this.insertIndexSQLToDDB.size() != 0) {
            if (!this.insertIndexSQLToDDB.containsKey(index)) {
                throw new SQLException("paramIndex is out of range");
            }
            index = this.insertIndexSQLToDDB.get(index);
        }
        return index;
    }

    private void bindNull(int paramIndex) throws SQLException {
        int index = this.getDataIndexBySQLIndex(paramIndex);
        if (this.sqlDmlType == 1) {
            Vector column = this.columnBindValues.get(index).getBindValues();
            try {
                int typeValue = column.getDataType().getValue();
                if (typeValue < 65) {
                    column.Append((Scalar)TypeCast.nullScalar(this.columnBindValues.get(index).getType()));
                }
                Vector tmp = BasicEntityFactory.instance().createVectorWithDefaultValue(Entity.DATA_TYPE.valueOf((int)(typeValue - 64)), 0, 0);
                column.Append(tmp);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            this.bufferArea[paramIndex - 1] = new BindValue(TypeCast.nullScalar(this.columnBindValues.get(index).getType()), false);
        }
    }

    private void combineOneRowData(boolean isBatch) throws SQLException {
        if (this.sqlDmlType == 1) {
            this.checkInsertBindsLegal(isBatch);
            if (isBatch) {
                for (ColumnBindValue column : this.columnBindValues) {
                    if (column.getBindValues().rows() == this.batchSize) continue;
                    Vector columnCol = column.getBindValues();
                    try {
                        if (columnCol.getDataType().getValue() < 65) {
                            columnCol.Append((Scalar)BasicEntityFactory.createScalar((Entity.DATA_TYPE)columnCol.getDataType(), null, (int)column.getScale()));
                            continue;
                        }
                        columnCol.Append((Vector)BasicEntityFactory.createScalar((Entity.DATA_TYPE)columnCol.getDataType(), null, (int)column.getScale()));
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
            }
        } else {
            this.sqlBuffer.add(this.generateSQL());
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            if (this.isPreparedStatement) {
                this.combineOneRowData(false);
                ResultSet resultSet = super.executeQuery(this.sqlBuffer.get(0));
                return resultSet;
            }
            ResultSet resultSet = super.executeQuery(this.sqlBuffer.get(0));
            return resultSet;
        }
        finally {
            if (this.isPreparedStatement) {
                this.clearBatch();
            }
        }
    }

    private void checkInsertBindsLegal(boolean isBatch) throws SQLException {
        int rows;
        int n = rows = isBatch ? this.batchSize : 1;
        if (this.insertIndexSQLToDDB.size() == 0) {
            for (ColumnBindValue bindValue : this.columnBindValues) {
                if (bindValue.getBindValues().rows() == rows) continue;
                throw new SQLException("The column " + bindValue.getColName() + " is not set.");
            }
        } else {
            for (Integer index : this.insertIndexSQLToDDB.keySet()) {
                if (this.columnBindValues.get(this.insertIndexSQLToDDB.get(index)).getBindValues().rows() == rows) continue;
                throw new SQLException("The column " + this.columnBindValues.get(this.insertIndexSQLToDDB.get(index)).getColName() + " is not set.");
            }
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            if (this.isPreparedStatement) {
                this.combineOneRowData(false);
                if (this.sqlDmlType == 1) {
                    int[] ret = this.tableAppend(false);
                    if (ret[0] == -2) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
                int ret = super.executeUpdate(this.sqlBuffer.get(0));
                return ret;
            }
            int ret = super.executeUpdate(this.sqlBuffer.get(0));
            return ret;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            this.clearBatch();
        }
    }

    private int[] tableAppend(boolean isBatch) throws SQLException {
        List<Vector> arguments = this.createDFSArguments(isBatch);
        ArrayList colNames = new ArrayList();
        this.columnBindValues.forEach(e -> colNames.add(e.getColName()));
        BasicTable basicTable = new BasicTable(colNames, arguments);
        ArrayList<Entity> param = new ArrayList<Entity>();
        param.add((Entity)basicTable);
        try {
            int size = ((Scalar)this.connection.run("tableInsert{" + this.tableName + "}", param)).getNumber().intValue();
            int[] value = new int[arguments.get(0).rows()];
            if (arguments.get(0).rows() != size) {
                Arrays.fill(value, -3);
            } else {
                Arrays.fill(value, -2);
            }
            return value;
        }
        catch (Exception e2) {
            throw new SQLException(e2);
        }
    }

    private List<Vector> createDFSArguments(boolean isBatch) throws SQLException {
        if (!isBatch) {
            for (ColumnBindValue column : this.columnBindValues) {
                if (column.getBindValues().rows() == 1) continue;
                Vector columnCol = column.getBindValues();
                try {
                    if (columnCol.getDataType().getValue() < 65) {
                        columnCol.Append((Scalar)BasicEntityFactory.createScalar((Entity.DATA_TYPE)columnCol.getDataType(), null, (int)column.getScale()));
                        continue;
                    }
                    columnCol.Append((Vector)BasicEntityFactory.createScalar((Entity.DATA_TYPE)columnCol.getDataType(), null, (int)column.getScale()));
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
        }
        return this.columnBindValues.stream().map(ColumnBindValue::getBindValues).collect(Collectors.toList());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.sqlDmlType == 1) {
            this.bindNull(parameterIndex);
        } else {
            String bindValue;
            switch (sqlType) {
                case 12: {
                    bindValue = "";
                    break;
                }
                case 1111: {
                    bindValue = new Void();
                    break;
                }
                default: {
                    bindValue = new Void();
                }
            }
            this.bufferArea[parameterIndex - 1] = new BindValue(bindValue, true);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.bind(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.bind(parameterIndex, x.doubleValue());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Driver.unused("setUnicodeStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void clearParameters() throws SQLException {
        if (Objects.nonNull(this.bufferArea)) {
            Arrays.fill(this.bufferArea, null);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            switch (this.sqlDmlType) {
                case 0: 
                case 4: {
                    ResultSet resultSet_ = this.executeQuery();
                    this.resultSets.offerLast(resultSet_);
                    this.objectQueue.offer(resultSet_);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.objectQueue.offer(this.executeUpdate());
                    break;
                }
                default: {
                    Entity entity;
                    if (this.isPreparedStatement) {
                        this.combineOneRowData(false);
                    }
                    if ((entity = this.connection.run(this.sqlBuffer.get(0))) instanceof BasicTable) {
                        JDBCResultSet resultSet_ = new JDBCResultSet(this.connection, (JDBCStatement)this, entity, this.sqlBuffer.get(0), this.getMaxRows());
                        this.resultSets.offerLast(resultSet_);
                        this.objectQueue.offer(resultSet_);
                    }
                    this.clearBatch();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        if (this.objectQueue.isEmpty()) {
            return false;
        }
        this.result = this.objectQueue.poll();
        return this.result instanceof ResultSet;
    }

    @Override
    public void addBatch() throws SQLException {
        ++this.batchSize;
        this.combineOneRowData(true);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        Driver.unused("setRef not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        byte[] blobbyte = x.getBytes(1L, (int)x.length());
        String blobstring = new String(blobbyte);
        this.bind(parameterIndex, blobstring);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        Driver.unused("setArray not implemented");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (Objects.nonNull(this.resultSet)) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Driver.unused("setNull not implemented");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        Driver.unused("setURL not implemented");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Driver.unused("getParameterMetaData not implemented");
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        Driver.unused("setRowId not implemented");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.bind(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        Driver.unused("setNCharacterStream not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        Driver.unused("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        Driver.unused("setSQLXML not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        Driver.unused("setNCharacterStream not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        Driver.unused("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        Driver.unused("setObject not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        Driver.unused("setObject not implemented");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return 0L;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.columnBindValues = null;
        this.preProcessedSql = null;
        this.bufferArea = null;
    }

    private String preProcessSql(String sql, JDBCConnection con) {
        sql = Utils.changeCase(sql, con);
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if ((sql = sql.trim()).equals("select 1")) {
            sql = "select 1 as val";
        }
        return sql;
    }

    private String generateSQL() throws SQLException {
        if (Utils.isEmpty(this.preProcessedSql)) {
            throw new SQLException("preProcessedSql is null. ");
        }
        String[] sqlSplitByQuestionMark = this.preProcessedSql.split("\\?");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.bufferArea.length > sqlSplitByQuestionMark.length) {
            throw new SQLException("error size of bufferArea. ");
        }
        if (this.bufferArea.length != 0) {
            for (int i = 0; i < this.bufferArea.length; ++i) {
                if (this.bufferArea[i] == null || this.bufferArea[i].getValue() == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1));
                }
                stringBuilder.append(sqlSplitByQuestionMark[i]);
                stringBuilder.append(TypeCast.castDbString(this.bufferArea[i].getValue()));
            }
            if (sqlSplitByQuestionMark.length > this.bufferArea.length && Objects.nonNull(sqlSplitByQuestionMark[this.bufferArea.length])) {
                stringBuilder.append(sqlSplitByQuestionMark[this.bufferArea.length]);
            }
        } else {
            stringBuilder.append(sqlSplitByQuestionMark[0]);
        }
        return stringBuilder.toString();
    }
}

