/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicShort
extends AbstractScalar
implements Comparable<BasicShort> {
    private short value;

    public BasicShort(short value) {
        this.value = value;
    }

    public BasicShort(ExtendedDataInput in) throws IOException {
        this.value = in.readShort();
    }

    public short getShort() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == Short.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value = Short.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SHORT;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return (short)Short.MIN_VALUE;
        }
        return this.value;
    }

    public Short shortValue() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicShort) || o == null) {
            return false;
        }
        return this.value == ((BasicShort)o).value;
    }

    public int hashCode() {
        return new Short(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        if (this.value >= 0) {
            return this.value % buckets;
        }
        if (this.value == Short.MIN_VALUE) {
            return -1;
        }
        return (int)((0x100000000L + (long)this.value) % (long)buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    public void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public int compareTo(BasicShort o) {
        return Short.compare(this.value, o.value);
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

