/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.temporal.Temporal;

public class BasicFloat
extends AbstractScalar
implements Comparable<BasicFloat> {
    private float value;

    public BasicFloat(float value) {
        this.value = value;
    }

    public BasicFloat(ExtendedDataInput in) throws IOException {
        this.value = in.readFloat();
    }

    public float getFloat() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == -3.4028235E38f;
    }

    @Override
    public void setNull() {
        this.value = -3.4028235E38f;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_FLOAT;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return Float.valueOf(-3.4028235E38f);
        }
        return Float.valueOf(this.value);
    }

    public Float floatValue() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return Float.valueOf(this.value);
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        if (Float.isNaN(this.value) || Float.isInfinite(this.value)) {
            return String.valueOf(this.value);
        }
        if (Utils.SCALE < 0) {
            return new DecimalFormat("0.########").format(this.value);
        }
        if ((double)this.value >= 1.0E7) {
            BigDecimal bd = new BigDecimal(this.value);
            return bd.setScale(Utils.SCALE, RoundingMode.DOWN).toString();
        }
        if (this.value == 0.0f) {
            BigDecimal bd = new BigDecimal(this.value + "");
            return String.valueOf(0);
        }
        BigDecimal bd = new BigDecimal(this.value + "");
        return bd.setScale(Utils.SCALE, RoundingMode.DOWN).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicFloat) || o == null) {
            return false;
        }
        return this.value == ((BasicFloat)o).value;
    }

    public int hashCode() {
        return new Float(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return -1;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    public void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public int compareTo(BasicFloat o) {
        return Float.compare(this.value, o.value);
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

