/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

public class DeltaBitInput {
    public static final long[] MASK_ARRAY;
    public static final long[] BIT_SET_MASK;
    private final long[] longArray;
    private long lB;
    private int position = 0;
    private int bitsLeft = 0;

    public DeltaBitInput(long[] array) {
        this.longArray = array;
        this.flipByte();
    }

    public boolean readBit() {
        boolean bit = (this.lB & BIT_SET_MASK[this.bitsLeft - 1]) != 0L;
        --this.bitsLeft;
        this.checkAndFlipByte();
        return bit;
    }

    public long readBits(int bits) {
        long value = 0L;
        for (int i = 0; i < bits; ++i) {
            value <<= 1;
            value |= (this.lB & BIT_SET_MASK[this.bitsLeft - 1]) == 0L ? 0L : 1L;
            --this.bitsLeft;
            this.checkAndFlipByte();
        }
        return value;
    }

    private void flipByte() {
        this.lB = this.longArray[this.position++];
        this.bitsLeft = 64;
    }

    private void checkAndFlipByte() {
        if (this.bitsLeft == 0) {
            this.flipByte();
        }
    }

    public int getInt() {
        return (int)this.getLong(32);
    }

    public long getLong(int bits) {
        long value;
        if (bits <= this.bitsLeft) {
            value = this.lB >>> this.bitsLeft - bits & MASK_ARRAY[bits - 1];
            this.bitsLeft -= bits;
            this.checkAndFlipByte();
        } else {
            value = this.lB & MASK_ARRAY[this.bitsLeft - 1];
            this.flipByte();
            value <<= (bits -= this.bitsLeft);
            value |= this.lB >>> this.bitsLeft - bits;
            this.bitsLeft -= bits;
        }
        return value;
    }

    public int nextClearBit(int maxBits) {
        int val = 0;
        for (int i = 0; i < maxBits; ++i) {
            val <<= 1;
            boolean bit = this.readBit();
            if (!bit) break;
            val |= 1;
        }
        return val;
    }

    public void rollBack(int bits) {
        if (64 - this.bitsLeft >= bits) {
            this.bitsLeft += bits;
        } else {
            --this.position;
            this.bitsLeft = bits - 64 + this.bitsLeft;
        }
    }

    protected int getPosition() {
        return this.position;
    }

    static {
        int i;
        MASK_ARRAY = new long[64];
        long mask = 1L;
        long value = 0L;
        for (i = 0; i < MASK_ARRAY.length; ++i) {
            DeltaBitInput.MASK_ARRAY[i] = value |= (mask <<= 1);
        }
        BIT_SET_MASK = new long[64];
        for (i = 0; i < BIT_SET_MASK.length; ++i) {
            DeltaBitInput.BIT_SET_MASK[i] = 1L << i;
        }
    }
}

