/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.DBConnection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDBConnectionPoolConfig {
    private String hostName;
    private int port;
    private String userId;
    private String password;
    @Deprecated
    private int initialPoolSize = -1;
    private int minimumPoolSize = 5;
    private int maximumPoolSize = 5;
    private int idleTimeout;
    private String initialScript = null;
    private boolean compress = false;
    private boolean useSSL = false;
    private boolean usePython = false;
    private boolean loadBalance = false;
    private boolean enableHighAvailability = false;
    private String[] highAvailabilitySites = null;
    private int tryReconnectNums = -1;
    private boolean isMinimumPoolSizeUserSet = false;
    private boolean isMaximumPoolSizeUserSet = false;
    private static final Logger log = LoggerFactory.getLogger(DBConnection.class);

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port <= 0) {
            throw new RuntimeException("The port should be positive.");
        }
        this.port = port;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Deprecated
    public void setInitialPoolSize(int initialPoolSize) {
        if (initialPoolSize <= 0) {
            throw new RuntimeException("The number of connection pools should be positive.");
        }
        this.initialPoolSize = initialPoolSize;
    }

    public void setMinimumPoolSize(int minimumPoolSize) {
        this.minimumPoolSize = minimumPoolSize;
        this.isMinimumPoolSizeUserSet = true;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        this.isMaximumPoolSizeUserSet = true;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getInitialScript() {
        return this.initialScript;
    }

    public void setInitialScript(String initialScript) {
        this.initialScript = initialScript;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isUsePython() {
        return this.usePython;
    }

    public void setUsePython(boolean usePython) {
        this.usePython = usePython;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public boolean isEnableHighAvailability() {
        return this.enableHighAvailability;
    }

    public void setEnableHighAvailability(boolean enableHighAvailability) {
        this.enableHighAvailability = enableHighAvailability;
    }

    public String[] getHighAvailabilitySites() {
        return this.highAvailabilitySites;
    }

    public void setHighAvailabilitySites(String[] highAvailabilitySites) {
        this.highAvailabilitySites = highAvailabilitySites;
    }

    public void setTryReconnectNums(int tryReconnectNums) {
        this.tryReconnectNums = tryReconnectNums;
    }

    public int getTryReconnectNums() {
        return this.tryReconnectNums;
    }

    protected void validate() {
        this.hostName = SimpleDBConnectionPoolConfig.getNullIfEmpty(this.hostName);
        if (Objects.isNull(this.hostName)) {
            this.hostName = "localhost";
            log.warn("The param hostName not set, will use the default value 'localhost'");
        }
        if (!SimpleDBConnectionPoolConfig.checkHostNameValid(this.hostName)) {
            throw new RuntimeException(String.format("Invalid hostName: %s", this.hostName));
        }
        if (this.port <= 0) {
            this.port = 8848;
            log.warn("Invalid port, will use the default value 8848.");
        }
        this.userId = SimpleDBConnectionPoolConfig.getNullIfEmpty(this.userId);
        if (Objects.isNull(this.userId)) {
            this.userId = "";
            log.warn("Login needs userId.");
        }
        this.password = SimpleDBConnectionPoolConfig.getNullIfEmpty(this.password);
        if (Objects.isNull(this.password)) {
            this.password = "";
            log.warn("Login needs password.");
        }
        if (this.initialPoolSize > 0 && !this.isMinimumPoolSizeUserSet && !this.isMaximumPoolSizeUserSet) {
            this.minimumPoolSize = this.initialPoolSize;
            this.maximumPoolSize = this.initialPoolSize;
        }
        if (this.initialPoolSize < 0) {
            if (this.minimumPoolSize <= 0) {
                this.minimumPoolSize = 5;
                log.warn("The param 'minimumIdle' cannot less than or equal to 0, will use the default value 5.");
            }
            if (this.maximumPoolSize <= 0) {
                this.maximumPoolSize = 5;
                log.warn("The param 'maximumPoolSize' cannot less than or equal to 0, will use the default value 5.");
            }
            if (this.maximumPoolSize < this.minimumPoolSize) {
                this.maximumPoolSize = this.minimumPoolSize;
                log.warn("The param 'maximumPoolSize' cannot less than 'minimumIdle', 'maximumPoolSize' will be set equal to 'minimumIdle' value.");
            }
        } else {
            if (this.minimumPoolSize <= 0) {
                this.minimumPoolSize = 5;
                log.warn("The param 'minimumIdle' cannot less than or equal to 0, will use the default value 5.");
            }
            if (this.maximumPoolSize <= 0) {
                this.maximumPoolSize = 5;
                log.warn("The param 'maximumPoolSize' cannot less than or equal to 0, will use the default value 5.");
            }
            if (this.maximumPoolSize < this.minimumPoolSize) {
                this.maximumPoolSize = this.minimumPoolSize;
                log.warn("The param 'maximumPoolSize' cannot less than 'minimumIdle', 'maximumPoolSize' will be set equal to 'minimumIdle' value.");
            }
        }
        if (this.idleTimeout < 10000) {
            this.idleTimeout = 600000;
            log.warn("The param 'idleTimeout' cannot less than 10000ms\uff0c will use the default value 600000ms(10min)");
        }
    }

    private static String getNullIfEmpty(String text) {
        return text == null ? null : (text.trim().isEmpty() ? null : text.trim());
    }

    private static boolean checkHostNameValid(String hostName) {
        return hostName.equals("localhost") || SimpleDBConnectionPoolConfig.isIPV4(hostName) || SimpleDBConnectionPoolConfig.isIPV6(hostName) || SimpleDBConnectionPoolConfig.isDomain(hostName);
    }

    private static boolean isDomain(String hostName) {
        String regex = "^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z]{2,}$";
        return hostName.matches(regex);
    }

    private static boolean isIPV4(String hostName) {
        String regex = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
        if (!hostName.matches(regex)) {
            return false;
        }
        String[] parts = hostName.split("\\.");
        try {
            for (String segment : parts) {
                if (Integer.parseInt(segment) <= 255) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isIPV6(String hostName) {
        String regex = "(^((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4}){1}|:))|(([0-9A-Fa-f]{1,4}:){6}((:[0-9A-Fa-f]{1,4}){1}|((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:))|(([0-9A-Fa-f]{1,4}:){5}((:[0-9A-Fa-f]{1,4}){1,2}|:((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:))|(([0-9A-Fa-f]{1,4}:){4}((:[0-9A-Fa-f]{1,4}){1,3}|:((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:))|(([0-9A-Fa-f]{1,4}:){3}((:[0-9A-Fa-f]{1,4}){1,4}|:((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:))|(([0-9A-Fa-f]{1,4}:){2}((:[0-9A-Fa-f]{1,4}){1,5}|:((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:))|(([0-9A-Fa-f]{1,4}:){1}((:[0-9A-Fa-f]{1,4}){1,6}|:((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:))|(:((:[0-9A-Fa-f]{1,4}){1,7}|(:[fF]{4}){0,1}:((22[0-3]|2[0-1][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})([.](25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|([0-9]){1,2})){3})|:)))$)";
        return hostName.matches(regex);
    }
}

