/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.json;

import com.diffplug.spotless.FormatterFunc;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonPatch;
import java.util.List;
import java.util.Map;

public class JsonPatchFormatterFunc
implements FormatterFunc {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final List<Map<String, Object>> patch;
    private final String patchString;

    public JsonPatchFormatterFunc(String patchString) {
        this.patch = null;
        this.patchString = patchString;
    }

    public JsonPatchFormatterFunc(List<Map<String, Object>> patch) {
        this.patch = patch;
        this.patchString = null;
    }

    @Override
    public String apply(String input) throws Exception {
        JsonNode patchNode = this.patch == null ? this.objectMapper.readTree(this.patchString) : this.objectMapper.valueToTree(this.patch);
        JsonNode inputNode = this.objectMapper.readTree(input);
        JsonNode patchedNode = JsonPatch.apply((JsonNode)patchNode, (JsonNode)inputNode);
        return this.objectMapper.writeValueAsString((Object)patchedNode);
    }
}

