/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class DiktatStep {
    private static final String DEFAULT_VERSION = "1.0.1";
    static final String NAME = "diktat";
    static final String PACKAGE_DIKTAT = "org.cqfn.diktat";
    static final String PACKAGE_KTLINT = "com.pinterest.ktlint";
    static final String MAVEN_COORDINATE = "org.cqfn.diktat:diktat-rules:";

    private DiktatStep() {
    }

    public static String defaultVersionDiktat() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return DiktatStep.create(DiktatStep.defaultVersionDiktat(), provisioner);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner) {
        return DiktatStep.create(versionDiktat, provisioner, Collections.emptyMap(), null);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, Collections.emptyMap(), config);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, Map<String, String> userData, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, false, userData, config);
    }

    public static FormatterStep createForScript(String versionDiktat, Provisioner provisioner, @Nullable FileSignature config) {
        return DiktatStep.createForScript(versionDiktat, provisioner, Collections.emptyMap(), config);
    }

    public static FormatterStep createForScript(String versionDiktat, Provisioner provisioner, Map<String, String> userData, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, true, userData, config);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, boolean isScript, Map<String, String> userData, @Nullable FileSignature config) {
        Objects.requireNonNull(versionDiktat, "versionDiktat");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(versionDiktat, provisioner, isScript, userData, config), State::createFormat);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        @Nullable
        private final FileSignature config;
        private final String pkg;
        private final String pkgKtlint;
        final JarState jar;
        private final TreeMap<String, String> userData;

        State(String versionDiktat, Provisioner provisioner, boolean isScript, Map<String, String> userData, @Nullable FileSignature config) throws IOException {
            HashSet<String> pkgSet = new HashSet<String>();
            pkgSet.add(DiktatStep.MAVEN_COORDINATE + versionDiktat);
            this.userData = new TreeMap<String, String>(userData);
            this.pkg = DiktatStep.PACKAGE_DIKTAT;
            this.pkgKtlint = DiktatStep.PACKAGE_KTLINT;
            this.jar = JarState.from(pkgSet, provisioner);
            this.isScript = isScript;
            this.config = config;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jar.getClassLoader();
            if (this.config != null) {
                System.setProperty("diktat.config.path", this.config.getOnlyFile().getAbsolutePath());
            }
            Class<?> ruleSetProviderClass = classLoader.loadClass(this.pkg + ".ruleset.rules.DiktatRuleSetProvider");
            Object diktatRuleSet = ruleSetProviderClass.getMethod("get", new Class[0]).invoke(ruleSetProviderClass.newInstance(), new Object[0]);
            List<Object> ruleSets = Collections.singletonList(diktatRuleSet);
            Class<?> function2Interface = classLoader.loadClass("kotlin.jvm.functions.Function2");
            Class<?> lintErrorClass = classLoader.loadClass(this.pkgKtlint + ".core.LintError");
            Method detailGetter = lintErrorClass.getMethod("getDetail", new Class[0]);
            Method lineGetter = lintErrorClass.getMethod("getLine", new Class[0]);
            Method colGetter = lintErrorClass.getMethod("getCol", new Class[0]);
            Class<?> ktlintClass = classLoader.loadClass(this.pkgKtlint + ".core.KtLint");
            Object ktlint = ktlintClass.getDeclaredField("INSTANCE").get(null);
            Class<?> paramsClass = classLoader.loadClass(this.pkgKtlint + ".core.KtLint$Params");
            Constructor<?> constructor = paramsClass.getConstructor(String.class, String.class, Iterable.class, Map.class, function2Interface, Boolean.TYPE, String.class, Boolean.TYPE);
            Method formatterMethod = ktlintClass.getMethod("format", paramsClass);
            FormatterFunc.NeedsFile formatterFunc = (input, file) -> {
                ArrayList errors = new ArrayList();
                Object formatterCallback = Proxy.newProxyInstance(classLoader, new Class[]{function2Interface}, (proxy, method, args) -> {
                    Object lintError = args[0];
                    boolean corrected = (Boolean)args[1];
                    if (!corrected) {
                        errors.add(lintError);
                    }
                    return null;
                });
                this.userData.put("file_path", file.getAbsolutePath());
                try {
                    Object params = constructor.newInstance(file.getName(), input, ruleSets, this.userData, formatterCallback, this.isScript, null, false);
                    String result = (String)formatterMethod.invoke(ktlint, params);
                    if (!errors.isEmpty()) {
                        StringBuilder error = new StringBuilder("");
                        error.append("There are ").append(errors.size()).append(" unfixed errors:");
                        for (Object er : errors) {
                            String detail = (String)detailGetter.invoke(er, new Object[0]);
                            int line = (Integer)lineGetter.invoke(er, new Object[0]);
                            int col = (Integer)colGetter.invoke(er, new Object[0]);
                            error.append(System.lineSeparator()).append("Error on line: ").append(line).append(", column: ").append(col).append(" cannot be fixed automatically").append(System.lineSeparator()).append(detail);
                        }
                        throw new AssertionError(error);
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw ThrowingEx.unwrapCause(e);
                }
            };
            return formatterFunc;
        }
    }
}

