/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.maven;

import com.dfssi.maven.Shell;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start-script", defaultPhase=LifecyclePhase.PACKAGE)
public class StartMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}")
    private File basedir;
    @Parameter(defaultValue="${project.build.finalName}")
    private String jarName;
    @Parameter(defaultValue="dev")
    private String active;
    @Parameter
    private String loggingConfig;
    @Parameter
    private String log4jConfigurationFile;
    @Parameter(defaultValue="1024m")
    private String Xmx;
    @Parameter(defaultValue="1024m")
    private String Xms;
    @Parameter(defaultValue="512m")
    private String Xmn;
    @Parameter
    private String Xss;
    @Parameter
    private String staticLocations;
    @Parameter(defaultValue="false")
    private boolean window;

    public void execute() throws MojoExecutionException {
        try {
            String s;
            File linux;
            File f = new File(this.basedir, "target/bin");
            if (!f.exists()) {
                f.mkdirs();
            }
            if ((linux = new File(f, "service.sh")).exists()) {
                linux.delete();
            }
            String serverName = this.jarName + "-" + this.active;
            try (FileWriter lw = new FileWriter(linux);){
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("jarName", this.jarName);
                map.put("active", this.active);
                s = "";
                if (Shell.isNotBlank(this.loggingConfig)) {
                    s = s + " -Dlogging.config=" + this.loggingConfig;
                }
                if (Shell.isNotBlank(this.log4jConfigurationFile)) {
                    s = s + " -Dlog4j.configurationFile=" + this.log4jConfigurationFile;
                }
                if (Shell.isNotBlank(this.staticLocations)) {
                    s = s + " -Dspring.resources.static-locations=" + this.staticLocations;
                }
                if (Shell.isNotBlank(this.Xmx)) {
                    s = s + " -Xmx" + this.Xmx;
                }
                if (Shell.isNotBlank(this.Xms)) {
                    s = s + " -Xms" + this.Xms;
                }
                if (Shell.isNotBlank(this.Xmn)) {
                    s = s + " -Xmn" + this.Xmn;
                }
                if (Shell.isNotBlank(this.Xss)) {
                    s = s + " -Xss" + this.Xss;
                }
                map.put("other", s);
                lw.write(Shell.convertToContent(map));
            }
            if (!this.window) {
                return;
            }
            File window = new File(f, "service.bat");
            if (window.exists()) {
                window.delete();
            }
            try (FileWriter ww = new FileWriter(window);){
                s = "java -server -Dname=" + serverName + " -Dloader.path=../lib/libs -Dspring.profiles.active=" + this.active;
                if (Shell.isNotBlank(this.loggingConfig)) {
                    s = s + " -Dlogging.config=" + this.loggingConfig;
                }
                if (Shell.isNotBlank(this.log4jConfigurationFile)) {
                    s = s + " -Dlog4j.configurationFile=" + this.log4jConfigurationFile;
                }
                s = s + " -Dspring.config.location=../config/";
                if (Shell.isNotBlank(this.Xmx)) {
                    s = s + " -Xmx" + this.Xmx;
                }
                if (Shell.isNotBlank(this.Xms)) {
                    s = s + " -Xms" + this.Xms;
                }
                if (Shell.isNotBlank(this.Xmn)) {
                    s = s + " -Xmn" + this.Xmn;
                }
                if (Shell.isNotBlank(this.Xss)) {
                    s = s + " -Xss" + this.Xss;
                }
                s = s + " -jar ../lib/" + this.jarName + ".jar";
                if (Shell.isNotBlank(this.staticLocations)) {
                    s = s + " --spring.resources.static-locations=" + this.staticLocations;
                }
                ww.write(s);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file", (Exception)e);
        }
    }
}

