/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Shell {
    private static String script = "APP_NAME=#{jarName}-#{active}\n#\u4f7f\u7528\u8bf4\u660e\uff0c\u7528\u6765\u63d0\u793a\u8f93\u5165\u53c2\u6570\nusage() {\n    echo \"Usage: sh service.sh [start|stop|restart|status]\"\n    exit 1\n}\n\n#\u68c0\u67e5\u7a0b\u5e8f\u662f\u5426\u5728\u8fd0\u884c\nis_exist(){\n  pid=`ps -ef|grep $APP_NAME|grep -v grep|awk '{print $2}'`\n  #\u5982\u679c\u4e0d\u5b58\u5728\u8fd4\u56de1\uff0c\u5b58\u5728\u8fd4\u56de0\n  if [ -z \"${pid}\" ]; then\n    return 1\n  else\n    return 0\n  fi\n}\n\n#\u542f\u52a8\u65b9\u6cd5\nstart(){\n  is_exist\n  if [ $? -eq 0 ]; then\n    echo \"${APP_NAME} is already running. pid=${pid}\"\n  else\n    #-Dspring.config.location=../config/\n    #-Dlogging.config=../config/logback.xml\n    #-Dlog4j.configurationFile=../config/log4j2.xml\n    rm -f ../nohup\n    nohup java -server \\\n               -Dname=${APP_NAME} \\\n               -Dloader.path=../lib/libs \\\n               -Dspring.profiles.active=#{active} \\\n               -Dspring.config.location=../config/ \\\n              #{other} \\\n               -jar ../lib/#{jarName}.jar \\\n               >../nohup 2>&1 &\n    echo \"${APP_NAME} is start running\"\n  fi\n}\n\n#\u505c\u6b62\u65b9\u6cd5\nstop(){\n  is_exist\n  if [ $? -eq \"0\" ]; then\n    kill $pid\n    echo \"${APP_NAME} is stop\"\n  else\n    echo \"${APP_NAME} is not running\"\n  fi\n}\n\n#\u8f93\u51fa\u8fd0\u884c\u72b6\u6001\nstatus(){\n  is_exist\n  if [ $? -eq \"0\" ]; then\n    echo \"${APP_NAME} is running. Pid is ${pid}\"\n  else\n    echo \"${APP_NAME} is NOT running.\"\n  fi\n}\n\n#\u91cd\u542f\nrestart(){\n  stop\n  sleep 3\n  start\n}\n\n#\u6839\u636e\u8f93\u5165\u53c2\u6570\uff0c\u9009\u62e9\u6267\u884c\u5bf9\u5e94\u65b9\u6cd5\uff0c\u4e0d\u8f93\u5165\u5219\u6267\u884c\u4f7f\u7528\u8bf4\u660e\ncase \"$1\" in\n  \"start\")\n    start\n    ;;\n  \"stop\")\n    stop\n    ;;\n  \"status\")\n    status\n    ;;\n  \"restart\")\n    restart\n    ;;\n  *)\n    usage\n    ;;\nesac";

    public static String convertToContent(Map<String, String> params) {
        String template = script;
        List<String> paramList = Shell.listTemplateParams(template);
        for (String param : paramList) {
            template = template.replaceAll("\\#\\{" + param + "\\}", params.get(param));
        }
        return template;
    }

    private static List<String> listTemplateParams(String template) {
        ArrayList<String> parameterList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("((?<=\\#\\{)[^\\}]*(?=\\}))");
        Matcher m = pattern.matcher(template);
        while (m.find()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                if (!Shell.isNotBlank(m.group(i))) continue;
                parameterList.add(m.group(i).trim());
            }
        }
        return parameterList;
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

