/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_wqg6;

import com.dfssi.access.common.listener.ConnAuthListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.xy_wqg6.Wqg6Msg;
import io.netty.channel.Channel;

public class Wqg6Connection
extends TcpConnection {
    private volatile Integer version;

    public Wqg6Connection(Channel channel, boolean server, ConnAuthListener authListener) {
        super(channel, server, authListener);
    }

    @Override
    public void initUpMsg(TcpProtoMsg upMsg) {
        this.version = ((Wqg6Msg)upMsg).version;
    }

    @Override
    public void fillUpMsg(TcpProtoMsg upMsg) throws Exception {
        Wqg6Msg msg = (Wqg6Msg)upMsg;
        if (msg.dataBuf.readableBytes() >= 6) {
            msg.collTime = ProtoUtil.readCollTime(msg.dataBuf);
        }
    }

    @Override
    public void fillDownMsg(TcpProtoMsg downMsg) {
        Wqg6Msg msg = (Wqg6Msg)downMsg;
        msg.version = this.version;
        if (msg.collTime == null) {
            msg.collTime = System.currentTimeMillis();
        }
    }
}

