/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_ne;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.xy_ne.NeMsg;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;

public class NeMsgCodec
implements MsgCodecListener {
    @Override
    public void initProperties(AccessProperties accessProperties) {
    }

    @Override
    public void encode(TcpProtoMsg downMsg, List<Object> list) {
        NeMsg protoMsg = (NeMsg)downMsg;
        int dataLen = protoMsg.dataBuf == null ? 0 : protoMsg.dataBuf.readableBytes();
        ByteBuf outBuf = Unpooled.buffer((int)(dataLen + 28));
        outBuf.writeByte(protoMsg.id);
        outBuf.writeByte(protoMsg.answerId);
        int len = ProtoUtil.writeString(outBuf, protoMsg.msgKey());
        if (len < 17) {
            outBuf.writeZero(17 - len);
        }
        outBuf.writeByte(1);
        outBuf.writeShort(dataLen + 6);
        ProtoUtil.writeCollTime(outBuf, protoMsg.collTime);
        if (dataLen > 0) {
            outBuf.writeBytes(protoMsg.dataBuf);
        }
        list.add(outBuf);
    }

    @Override
    public NeMsg decode(ChannelHandlerContext ctx, ByteBuf out, Class<? extends TcpProtoMsg> msgClass) {
        NeMsg protoMsg = new NeMsg();
        protoMsg.id = out.readUnsignedByte();
        protoMsg.answerId = out.readUnsignedByte();
        protoMsg.key = ProtoUtil.readString(out, 17);
        protoMsg.cryptType = out.readByte();
        out.skipBytes(2);
        protoMsg.dataBuf = out;
        return protoMsg;
    }
}

