/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_809;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.xy_809.Xy809Msg;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;

public class Xy809MsgCodec
implements MsgCodecListener {
    @Override
    public void initProperties(AccessProperties accessProperties) {
    }

    @Override
    public void encode(TcpProtoMsg downMsg, List<Object> list) {
        Xy809Msg protoMsg = (Xy809Msg)downMsg;
        int bodyLength = protoMsg.dataBuf != null ? protoMsg.dataBuf.readableBytes() : 0;
        ByteBuf buf = Unpooled.buffer((int)(bodyLength + 22));
        buf.writeInt(bodyLength + 26);
        buf.writeInt(protoMsg.sn);
        buf.writeShort(protoMsg.id);
        buf.writeInt(((Integer)protoMsg.key).intValue());
        buf.writeBytes(protoMsg.version);
        buf.writeBoolean(protoMsg.encrypt);
        buf.writeInt(protoMsg.decryptKey.intValue());
        if (bodyLength != 0) {
            buf.writeBytes(protoMsg.dataBuf);
        }
        list.add(buf);
    }

    @Override
    public Xy809Msg decode(ChannelHandlerContext ctx, ByteBuf out, Class<? extends TcpProtoMsg> msgClass) throws Exception {
        int dataLen = out.readableBytes() + 4;
        long packLen = out.readUnsignedInt();
        if (packLen != (long)dataLen) {
            throw new CodecException(ErrorCode.LEN_CHECK_FAILURE, "\u534f\u8bae\u6570\u636e\u5305\u5b9e\u9645\u957f\u5ea6(" + dataLen + ")\u4e0d\u7b49\u4e8e\u6570\u636e\u5305\u4e2d\u6807\u8bc6\u957f\u5ea6(" + packLen + ")");
        }
        Xy809Msg protoMsg = new Xy809Msg();
        protoMsg.sn = out.readInt();
        protoMsg.id = out.readUnsignedShort();
        protoMsg.key = Integer.valueOf(out.readInt());
        protoMsg.version = ProtoUtil.readBytes(out, 3);
        protoMsg.encrypt = out.readByte() != 0;
        protoMsg.decryptKey = out.readUnsignedInt();
        protoMsg.dataBuf = out;
        return protoMsg;
    }
}

