/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_809;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public interface Xy809Constant {
    public static final byte PACK_HEAD = 91;
    public static final byte PACK_TAIL = 93;

    public static int calcCRC(int crc, byte b) {
        for (int i = 0; i < 8; ++i) {
            boolean bit = (b >> 7 - i & 1) == 1;
            boolean c15 = (crc >> 15 & 1) == 1;
            crc <<= 1;
            if (!(c15 ^ bit)) continue;
            crc ^= 0x1021;
        }
        return crc;
    }

    public static ByteBuf encode(ByteBuf in) {
        ByteBuf out = Unpooled.buffer((int)32);
        out.writeByte(91);
        int crc = 65535;
        int writerIndex = in.writerIndex();
        for (int i = 0; i < writerIndex; ++i) {
            byte b = in.getByte(i);
            crc = Xy809Constant.calcCRC(crc, b);
            Xy809Constant.writeByte(out, b);
        }
        Xy809Constant.writeByte(out, (byte)(crc >> 8));
        Xy809Constant.writeByte(out, (byte)crc);
        out.writeByte(93);
        return out;
    }

    public static void writeByte(ByteBuf out, byte b) {
        switch (b) {
            case 91: {
                out.writeByte(90);
                out.writeByte(1);
                break;
            }
            case 90: {
                out.writeByte(90);
                out.writeByte(2);
                break;
            }
            case 93: {
                out.writeByte(94);
                out.writeByte(1);
                break;
            }
            case 94: {
                out.writeByte(94);
                out.writeByte(2);
                break;
            }
            default: {
                out.writeByte((int)b);
            }
        }
    }
}

