/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.util;

import com.dfssi.access.common.util.ProtoUtil;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class RSAUtil {
    private static final String RSA = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static KeyPair getKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(RSA);
        generator.initialize(1024);
        return generator.generateKeyPair();
    }

    public static PublicKey getPublicKey(ByteBuf byteBuf) throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger e = new BigInteger(1, ProtoUtil.readBytes(byteBuf, 4));
        BigInteger n = new BigInteger(1, ProtoUtil.readBytes(byteBuf, 128));
        return KeyFactory.getInstance(RSA).generatePublic(new RSAPublicKeySpec(n, e));
    }

    public static void encrypt(ByteBuf byteBuf, PublicKey publicKey) throws Exception {
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, publicKey);
        byteBuf.markReaderIndex();
        byte[] data = ProtoUtil.readBytes(byteBuf, byteBuf.readableBytes());
        byteBuf.resetReaderIndex();
        byteBuf.writerIndex(byteBuf.readerIndex());
        int inputLen = data.length;
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byteBuf.writeBytes(cipher.doFinal(data, offset, Math.min(inputLen - offset, 117)));
            offset = ++i * 117;
        }
    }

    public static void decrypt(ByteBuf byteBuf, PrivateKey privateKey) throws Exception {
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, privateKey);
        byteBuf.markReaderIndex();
        byte[] data = ProtoUtil.readBytes(byteBuf, byteBuf.readableBytes());
        byteBuf.resetReaderIndex();
        byteBuf.writerIndex(byteBuf.readerIndex());
        int inputLen = data.length;
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byteBuf.writeBytes(cipher.doFinal(data, offset, Math.min(inputLen - offset, 128)));
            offset = ++i * 128;
        }
    }
}

