/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.util;

import com.dfssi.access.common.codec.PackDecoder;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.tcp.TcpConnection;
import com.google.common.io.BaseEncoding;
import io.netty.buffer.ByteBuf;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public interface ProtoUtil {
    public static final AttributeKey<TcpConnection> CONN_KEY = AttributeKey.newInstance((String)"connection");
    public static final AttributeKey<PackDecoder> DECODER_KEY = AttributeKey.newInstance((String)"decoder");
    public static final BaseEncoding ENCODING_16 = BaseEncoding.base16();
    public static final BaseEncoding ENCODING_16_SPACE = ENCODING_16.withSeparator(" ", 2);
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyMMddHHmmss");
    public static final Charset DEFAULT_CHARSET = Charset.forName("GBK");
    public static final String JOIN_CHAT = "_";

    public static String wholeStr(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.writerIndex()];
        byteBuf.getBytes(0, bytes);
        return ENCODING_16.encode(bytes);
    }

    public static String wholeStrWithSpace(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.writerIndex()];
        byteBuf.getBytes(0, bytes);
        return ENCODING_16_SPACE.encode(bytes);
    }

    public static String byte2BinaryStr(byte value) {
        return Integer.toBinaryString((value & 0xFF) + 256).substring(1);
    }

    public static long readBcdLong(ByteBuf byteBuf, int len) {
        return Long.parseLong(ENCODING_16.encode(ProtoUtil.readBytes(byteBuf, len)));
    }

    public static void writeBcdLong(ByteBuf byteBuf, long value, int len) {
        byte[] bcd = new byte[len];
        long l = value;
        for (int i = 0; i < len; ++i) {
            byte lo = (byte)(l % 10L);
            byte hi = (byte)((l /= 10L) % 10L);
            l /= 10L;
            bcd[len - 1 - i] = (byte)(hi << 4 | lo);
        }
        byteBuf.writeBytes(bcd);
    }

    public static long readBcdTime(ByteBuf byteBuf) throws CodecException {
        return ProtoUtil.getTimestamp(ENCODING_16.encode(ProtoUtil.readBytes(byteBuf, 6)));
    }

    public static void writeBcdTime(ByteBuf byteBuf, long timestamp) {
        ProtoUtil.writeBcdLong(byteBuf, Long.parseLong(DATE_FORMAT.format(ProtoUtil.getDataTime(timestamp))), 6);
    }

    public static long readCollTime(ByteBuf byteBuf) throws CodecException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append(String.format("%02d", byteBuf.readByte()));
        }
        return ProtoUtil.getTimestamp(sb.toString());
    }

    public static void writeCollTime(ByteBuf byteBuf, long timestamp) {
        String format = DATE_FORMAT.format(ProtoUtil.getDataTime(timestamp));
        for (int i = 0; i < 6; ++i) {
            byteBuf.writeByte((int)Short.parseShort(format.substring(i * 2, (i + 1) * 2)));
        }
    }

    public static LocalDateTime getDataTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static long getTimestamp(String yyMMddHHmmss) throws CodecException {
        try {
            return LocalDateTime.parse(yyMMddHHmmss, DATE_FORMAT).toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new CodecException(ErrorCode.FORMAT_TIME_ERROR, yyMMddHHmmss + "\u4e0d\u80fd\u8f6c\u6362\u4e3ayyMMddHHmmss");
        }
    }

    public static String formatId(int id) {
        return "0x" + String.format("%04x", id);
    }

    public static boolean isBitOne(int num, int i) {
        return (num & 1 << i) != 0;
    }

    public static boolean isBitZero(int num, int i) {
        return (num & 1 << i) == 0;
    }

    public static boolean isBitOne(long num, int i) {
        return (num & (long)(1 << i)) != 0L;
    }

    public static boolean isBitZero(long num, int i) {
        return (num & (long)(1 << i)) == 0L;
    }

    public static int setBitOne(int num, int i) {
        return num | 1 << i;
    }

    public static int setBitZero(int num, int i) {
        return num & ~(1 << i);
    }

    public static long setBitOne(long num, int i) {
        return num | (long)(1 << i);
    }

    public static long setBitZero(long num, int i) {
        return num & (long)(~(1 << i));
    }

    public static int getBitIndex(int num, int start, int end) {
        int subLen = end - start;
        if (subLen <= 0) {
            throw new IndexOutOfBoundsException("index out of range: " + subLen);
        }
        return num >> start & (1 << subLen) - 1;
    }

    public static String readString(ByteBuf dataBuf, int dataLen) {
        byte[] data = new byte[dataLen];
        dataBuf.readBytes(data);
        for (int i = dataLen; i > 0; --i) {
            if (data[i - 1] == 0) continue;
            return new String(data, 0, i, DEFAULT_CHARSET);
        }
        return "";
    }

    public static byte[] readBytes(ByteBuf buf, int dataLen) {
        byte[] data = new byte[dataLen];
        buf.readBytes(data);
        return data;
    }

    public static int writeString(ByteBuf buf, String src) {
        if (src == null) {
            return 0;
        }
        byte[] bytes = src.getBytes(DEFAULT_CHARSET);
        buf.writeBytes(bytes);
        return bytes.length;
    }

    public static int writeStringWithLen(ByteBuf buf, String src) {
        if (src != null) {
            byte[] data = src.getBytes(DEFAULT_CHARSET);
            buf.writeByte(data.length);
            buf.writeBytes(data);
            return data.length;
        }
        buf.writeByte(0);
        return 0;
    }

    public static String encode(String numStr, int salt) {
        Base64.Encoder encoder;
        String encoderStr;
        numStr = numStr.substring(1);
        int length = numStr.length();
        StringBuilder stringBuilder = new StringBuilder();
        while (length / 4 > 0) {
            String intStr = numStr.substring(0, 4);
            String hexStr = Integer.toHexString(Integer.parseInt(intStr) ^ salt);
            numStr = numStr.substring(4);
            length = numStr.length();
            stringBuilder.append(hexStr);
        }
        if (length != 0) {
            String hexStr = Integer.toHexString(Integer.parseInt(numStr) ^ salt);
            stringBuilder.append(hexStr);
        }
        if ((encoderStr = (encoder = Base64.getMimeEncoder(8, ",".getBytes())).encodeToString(stringBuilder.toString().getBytes())).length() < 8) {
            encoderStr = encoderStr + encoder.encodeToString(String.valueOf(salt).getBytes());
        }
        if (encoderStr.length() > 8) {
            encoderStr = encoderStr.substring(0, 8);
        }
        return encoderStr;
    }

    public static <T> T getBean(ApplicationContext applicationContext, Class<T> clazz) {
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (BeansException e) {
            return null;
        }
    }
}

