/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    public final Channel channel;
    public final String remoteHost;
    public final int remotePort;

    public Connection(Channel channel) {
        this.channel = channel;
        InetSocketAddress isa = (InetSocketAddress)channel.remoteAddress();
        this.remoteHost = isa.getAddress().getHostAddress();
        this.remotePort = isa.getPort();
    }

    public ChannelFuture close(String closeCause) {
        this.info("{}", closeCause);
        return this.channel.close();
    }

    public void debug(String infoDesc, Object ... objects) {
        if (log.isDebugEnabled()) {
            log.debug(this.desc() + infoDesc, objects);
        }
    }

    public void info(String infoDesc, Object ... objects) {
        log.info(this.desc() + infoDesc, objects);
    }

    public void error(Throwable throwable) {
        log.error(this.desc(), throwable);
    }

    public void error(String errorDesc, Throwable throwable) {
        log.error(this.desc() + errorDesc, throwable);
    }

    public String desc() {
        return "[" + this.remoteHost + ":" + this.remotePort + "] ";
    }
}

