/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.server;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.codec.MarshallCodec;
import com.dfssi.access.common.message.ConnOccupation;
import com.dfssi.access.common.message.MethodReturnMeta;
import com.dfssi.access.common.message.ServerInfo;
import com.dfssi.access.common.server.ServerMasterHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class ServerMasterRunner
implements ApplicationListener<ApplicationStartedEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ServerMasterRunner.class);
    private AccessProperties.Master master;
    private ConfigurableApplicationContext applicationContext;
    @Autowired(required=false)
    private ConnListener connListener;
    private volatile boolean reconnect = true;
    private volatile Channel channel;

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        this.applicationContext = applicationStartedEvent.getApplicationContext();
        this.master = ((AccessProperties)this.applicationContext.getBean(AccessProperties.class)).getMaster();
        final AccessProperties.Server server = ((AccessProperties)this.applicationContext.getBean(AccessProperties.class)).getServer();
        final EventLoopGroup eventLoopGroup = (EventLoopGroup)this.applicationContext.getBean(EventLoopGroup.class);
        final Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{MarshallCodec.buildDecoder(), MarshallCodec.buildEncoder(), new IdleStateHandler(0L, (long)ServerMasterRunner.this.master.getIdleTimeout(), 0L, TimeUnit.SECONDS), new ServerMasterHandler((ApplicationContext)ServerMasterRunner.this.applicationContext, ServerMasterRunner.this)});
            }
        });
        eventLoopGroup.schedule(new Runnable(){

            @Override
            public void run() {
                bootstrap.connect(ServerMasterRunner.this.master.getIp(), ServerMasterRunner.this.master.getPort()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    if (channelFuture.isSuccess()) {
                        log.info("Master[{}:{}]\u8fde\u63a5\u6210\u529f", (Object)ServerMasterRunner.this.master.getIp(), (Object)ServerMasterRunner.this.master.getPort());
                        ServerMasterRunner.this.channel = channelFuture.channel();
                        ServerMasterRunner.this.channel.writeAndFlush((Object)new ServerInfo(ServerMasterRunner.this.master.getConnName(), server.getAgreement(), server.getPort(), server.isEnableMonitor()));
                        ServerMasterRunner.this.channel.closeFuture().addListener(closeFuture -> {
                            ServerMasterRunner.this.channel = null;
                            if (ServerMasterRunner.this.reconnect) {
                                log.info("\u68c0\u6d4b\u5230\u4e0eMaster[{}:{}]\u65ad\u5f00\u8fde\u63a5\uff0c\u9a6c\u4e0a\u91cd\u8fde", (Object)ServerMasterRunner.this.master.getIp(), (Object)ServerMasterRunner.this.master.getPort());
                                eventLoopGroup.schedule((Runnable)this, 0L, TimeUnit.SECONDS);
                            } else {
                                log.info("\u4e3b\u52a8\u4e0eMaster[{}:{}]\u65ad\u5f00\u8fde\u63a5", (Object)ServerMasterRunner.this.master.getIp(), (Object)ServerMasterRunner.this.master.getPort());
                            }
                        });
                        if (ServerMasterRunner.this.connListener != null) {
                            ServerMasterRunner.this.connListener.connect();
                        }
                    } else {
                        log.info("Master[{}:{}]\u8fde\u63a5\u5931\u8d25\uff0c{}\u79d2\u540e\u91cd\u8fde", new Object[]{ServerMasterRunner.this.master.getIp(), ServerMasterRunner.this.master.getPort(), ServerMasterRunner.this.master.getConnWaitTime()});
                        eventLoopGroup.schedule((Runnable)this, (long)ServerMasterRunner.this.master.getConnWaitTime(), TimeUnit.SECONDS);
                    }
                }));
            }
        }, 0L, TimeUnit.SECONDS);
    }

    public void destroy() throws Exception {
        if (this.channel != null) {
            this.reconnect = false;
            this.channel.close().sync();
            this.channel = null;
        }
    }

    public void replyResult(String returnKey, Object object) {
        if (this.channel == null) {
            log.info("Master[{}:{}]\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00\uff0c\u65e0\u6cd5\u56de\u590d\u6d88\u606f", (Object)this.master.getIp(), (Object)this.master.getPort());
        } else {
            this.channel.writeAndFlush((Object)new MethodReturnMeta(returnKey, object));
        }
    }

    public void connNameOccupied(ConnOccupation connOccupation) {
        log.error("[{}]\u5df2\u7ecf\u88ab\u5176\u4ed6conn[{}:{}]\u5360\u7528", new Object[]{this.master.getConnName(), connOccupation.remoteHost, connOccupation.remotePort});
        this.applicationContext.close();
    }

    public static interface ConnListener {
        public void connect();
    }
}

