/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.server;

import com.dfssi.access.common.annotation.CommandCall;
import com.dfssi.access.common.message.ConnOccupation;
import com.dfssi.access.common.message.MethodInvokeMeta;
import com.dfssi.access.common.message.MethodReturnMeta;
import com.dfssi.access.common.message.ReturnMsg;
import com.dfssi.access.common.remote.VoidResult;
import com.dfssi.access.common.server.ServerConnHandler;
import com.dfssi.access.common.server.ServerMasterRunner;
import com.dfssi.access.common.tcp.TcpCommand;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ServerMasterHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ServerMasterHandler.class);
    private final ApplicationContext applicationContext;
    private final ServerConnHandler serverConnHandler;
    private final ServerMasterRunner serverMasterRunner;

    public ServerMasterHandler(ApplicationContext applicationContext, ServerMasterRunner serverMasterRunner) {
        this.applicationContext = applicationContext;
        this.serverConnHandler = (ServerConnHandler)((Object)applicationContext.getBean(ServerConnHandler.class));
        this.serverMasterRunner = serverMasterRunner;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block10: {
            if (msg instanceof MethodInvokeMeta) {
                MethodInvokeMeta invokeMeta = (MethodInvokeMeta)msg;
                try {
                    if (invokeMeta.interfaceClass.isAnnotationPresent(CommandCall.class)) {
                        TcpCommand tcpCommand = (TcpCommand)invokeMeta.args[0];
                        tcpCommand.setCallBack(object -> this.serverMasterRunner.replyResult(methodInvokeMeta.returnKey, object));
                        this.serverConnHandler.sendCommand(tcpCommand);
                    } else {
                        Object targetObject = this.applicationContext.getBean(invokeMeta.interfaceClass);
                        if (invokeMeta.async) {
                            ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, new VoidResult()));
                        }
                        Method method = targetObject.getClass().getMethod(invokeMeta.methodName, invokeMeta.parameterTypes);
                        Object obj = method.invoke(targetObject, invokeMeta.args);
                        if (!invokeMeta.async) {
                            ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, obj == null ? new VoidResult() : obj));
                        }
                    }
                    break block10;
                }
                catch (BeansException e) {
                    log.error("\u8bf7\u5b9e\u73b0\u63a5\u53e3\u7c7b" + invokeMeta.interfaceClass, (Throwable)e);
                    ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, (Object)e));
                }
                catch (Exception e) {
                    log.error("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38", (Throwable)e);
                    if (!invokeMeta.async) {
                        ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, e));
                    }
                    break block10;
                }
            }
            if (msg instanceof ConnOccupation) {
                this.serverMasterRunner.connNameOccupied((ConnOccupation)msg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("\u6d88\u606f\u5904\u7406\u5f02\u5e38", cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            ctx.writeAndFlush((Object)new ReturnMsg());
        }
    }
}

