/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.server;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.codec.MethodAdapter;
import com.dfssi.access.common.codec.Pack2MsgCodec;
import com.dfssi.access.common.codec.Pack2PackCodec;
import com.dfssi.access.common.exception.RemoteException;
import com.dfssi.access.common.listener.ConnAuthListener;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.listener.MsgHandlerListener;
import com.dfssi.access.common.listener.PackCodecListener;
import com.dfssi.access.common.listener.ProtoMsgListener;
import com.dfssi.access.common.listener.ProtoPackListener;
import com.dfssi.access.common.listener.ServerConnListener;
import com.dfssi.access.common.tcp.TcpCommand;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ChannelHandler.Sharable
public class ServerConnHandler
extends ChannelInboundHandlerAdapter
implements ApplicationContextAware,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ServerConnHandler.class);
    private final Set<TcpConnection> unAuthConnections = Sets.newConcurrentHashSet();
    private final Map<String, TcpConnection> authConnections = Maps.newConcurrentMap();
    private final EventLoopGroup eventLoopGroup;
    private final AccessProperties.Server properties;
    private final ConnAuthListener authListener = new ConnAuthListener(){

        @Override
        public void authSuccess(String authKey, TcpConnection connection) {
            if (connection.isAuth()) {
                if (connection.getAuthKey().equals(authKey)) {
                    return;
                }
                ServerConnHandler.this.authConnections.remove(connection.getAuthKey());
                TcpConnection oldConnection = ServerConnHandler.this.authConnections.put(authKey, connection);
                if (oldConnection != null && connection.channel != oldConnection.channel) {
                    oldConnection.close("\u5efa\u7acb\u4e86\u65b0\u8fde\u63a5\uff0c\u65e7\u8fde\u63a5\u5173\u95ed");
                }
                connection.info("\u91cd\u65b0\u9274\u6743\u6210\u529f\uff0c\u65b0key:{}", authKey);
            } else {
                ServerConnHandler.this.unAuthConnections.remove(connection);
                TcpConnection oldConnection = ServerConnHandler.this.authConnections.put(authKey, connection);
                if (oldConnection != null && connection.channel != oldConnection.channel) {
                    oldConnection.close("\u5efa\u7acb\u4e86\u65b0\u8fde\u63a5\uff0c\u65e7\u8fde\u63a5\u5173\u95ed");
                }
                connection.info("\u9274\u6743\u6210\u529f\uff0ckey:{}\uff0c\u5f53\u524d\u5df2\u9274\u6743\u8fde\u63a5\u6570:{}", authKey, ServerConnHandler.this.authConnections.size());
            }
            if (ServerConnHandler.this.serverConnListener != null) {
                ServerConnHandler.this.eventLoopGroup.submit(() -> ServerConnHandler.this.serverConnListener.beAuthed(connection));
            }
        }

        @Override
        public void authFail(TcpConnection connection) {
            if (!connection.isAuth()) {
                return;
            }
            ServerConnHandler.this.authConnections.remove(connection.getAuthKey());
            ServerConnHandler.this.unAuthConnections.add(connection);
            connection.info("\u9274\u6743\u5931\u8d25\uff0c\u672a\u9274\u6743\u8fde\u63a5\u6570:{}", ServerConnHandler.this.unAuthConnections.size());
        }

        @Override
        public int maxErrorCount() {
            return ServerConnHandler.this.properties.getMaxErrorCount();
        }
    };
    private ApplicationContext applicationContext;
    @Autowired
    private MsgHandlerListener msgHandlerListener;
    @Autowired(required=false)
    private ServerConnListener serverConnListener;
    private volatile Channel serverChannel;

    public void sendCommand(TcpCommand tcpCommand) throws RemoteException {
        if (Strings.isBlank((String)tcpCommand.commandKey())) {
            throw new RemoteException("commandKey\u4e3a\u7a7a");
        }
        if (tcpCommand.msgKey() == null) {
            throw new RemoteException("msgKey\u4e3a\u7a7a");
        }
        TcpConnection conn = this.authConnections.get(tcpCommand.commandKey());
        if (conn == null) {
            throw new RemoteException("[" + tcpCommand.commandKey() + "]\u672a\u4e0a\u7ebf");
        }
        this.msgHandlerListener.sendListenerMsg(conn.channel, tcpCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object object) {
        TcpProtoMsg upMsg = (TcpProtoMsg)object;
        try {
            TcpConnection connection = (TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get();
            if (connection.notRecvMsg() && this.unAuthConnections.add(connection)) {
                connection.initUpMsg(upMsg);
                if (this.serverConnListener != null) {
                    this.serverConnListener.beCreated(connection, upMsg);
                }
                connection.info("\u6536\u5230first\u6d88\u606f\uff0c\u5f53\u524d\u672a\u9274\u6743\u8fde\u63a5\u6570:{}", this.unAuthConnections.size());
            }
            this.msgHandlerListener.handlerReceiveMsg(ctx, connection, upMsg, this.properties.isCheckAuth());
        }
        finally {
            upMsg.release();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        TcpConnection connection = this.properties.getAgreement().getTcpConnClass().getConstructor(Channel.class, Boolean.TYPE, ConnAuthListener.class).newInstance(ctx.channel(), true, this.authListener);
        connection.debug("\u5df2\u8fde\u63a5", new Object[0]);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        TcpConnection connection = (TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get();
        if (connection.notRecvMsg()) {
            connection.debug("\u5df2\u65ad\u5f00", new Object[0]);
        } else if (!connection.isAuth()) {
            this.unAuthConnections.remove(connection);
            connection.info("\u5df2\u65ad\u5f00\uff0c\u5f53\u524d\u672a\u9274\u6743\u8fde\u63a5\u6570:{}", this.unAuthConnections.size());
        } else if (connection == this.authConnections.get(connection.getAuthKey())) {
            this.authConnections.remove(connection.getAuthKey());
            if (this.serverConnListener != null) {
                this.eventLoopGroup.submit(() -> this.serverConnListener.beClosed(connection));
            }
            connection.info("\u5df2\u65ad\u5f00\uff0c\u5f53\u524d\u5df2\u9274\u6743\u8fde\u63a5\u6570:{}", this.authConnections.size());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            ((TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get()).close(this.properties.getIdleTimeout() + "\u79d2\u5185\u672a\u53d1\u9001\u6d88\u606f\uff0c\u8fde\u63a5\u5173\u95ed");
        }
    }

    public void run(String ... args) {
        NioEventLoopGroup bossThreadPool = new NioEventLoopGroup(1);
        final Pack2PackCodec pack2PackCodec = new Pack2PackCodec(ProtoUtil.getBean(this.applicationContext, ProtoPackListener.class), (PackCodecListener)this.applicationContext.getBean(PackCodecListener.class));
        final Pack2MsgCodec pack2MsgCodec = new Pack2MsgCodec(ProtoUtil.getBean(this.applicationContext, ProtoMsgListener.class), (MsgCodecListener)this.applicationContext.getBean(MsgCodecListener.class), (MethodAdapter)this.applicationContext.getBean(MethodAdapter.class), this.properties.getAgreement().getTcpMsgClass());
        this.serverChannel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossThreadPool, this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)2048)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{pack2PackCodec, pack2MsgCodec, new IdleStateHandler((long)ServerConnHandler.this.properties.getIdleTimeout(), 0L, 0L, TimeUnit.SECONDS), ServerConnHandler.this});
            }
        }).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).bind(this.properties.getPort()).syncUninterruptibly().channel();
        log.info("NettyServer[{}]\u5df2\u542f\u52a8", (Object)this.properties.getPort());
        this.serverChannel.closeFuture().addListener(arg_0 -> this.lambda$run$2((EventLoopGroup)bossThreadPool, arg_0));
    }

    @PreDestroy
    public void stop() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel = null;
        }
        for (TcpConnection value : this.unAuthConnections) {
            value.close("NettyServer[" + this.properties.getPort() + "]\u88ab\u5173\u95ed\u4e86");
        }
        for (TcpConnection value : this.authConnections.values()) {
            value.close("NettyServer[" + this.properties.getPort() + "]\u88ab\u5173\u95ed\u4e86");
        }
    }

    public ServerConnHandler(EventLoopGroup eventLoopGroup, AccessProperties.Server properties) {
        this.eventLoopGroup = eventLoopGroup;
        this.properties = properties;
    }

    public Set<TcpConnection> getUnAuthConnections() {
        return this.unAuthConnections;
    }

    public Map<String, TcpConnection> getAuthConnections() {
        return this.authConnections;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private /* synthetic */ void lambda$run$2(EventLoopGroup eventLoopGroup, Future future) throws Exception {
        eventLoopGroup.shutdownGracefully();
        log.info("NettyServer[{}]\u5df2\u7ecf\u88ab\u5173\u95ed", (Object)this.properties.getPort());
    }
}

