/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.server;

import com.dfssi.access.common.codec.MethodAdapter;
import com.dfssi.access.common.codec.MethodInvoker;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ServerAspect {
    private final AtomicLong connTotal = new AtomicLong();
    private final AtomicLong receiveRightPack = new AtomicLong();
    private final AtomicLong receiveAllPack = new AtomicLong();
    private final AtomicLong sendAllPack = new AtomicLong();
    private final AtomicLong waitHandleMsg = new AtomicLong();
    private final AtomicLong handleAllMsg = new AtomicLong();
    private final AtomicLong commandCount = new AtomicLong();
    private final AtomicLong replyCount = new AtomicLong();
    @Autowired
    private MethodAdapter methodAdapter;

    @Around(value="execution(* com.dfssi.access.common.listener.PackCodecListener.decode(..,java.util.List)) && args(..,list)", argNames="joinPoint, list")
    public void receiveByteAdd(ProceedingJoinPoint joinPoint, List<Object> list) throws Throwable {
        this.receiveAllPack.incrementAndGet();
        joinPoint.proceed();
        int packCount = list.size();
        if (packCount > 0) {
            this.receiveRightPack.addAndGet(packCount);
            this.waitHandleMsg.addAndGet(packCount);
        }
    }

    @After(value="execution(* com.dfssi.access.common.listener.PackCodecListener.encode(*))")
    public void sendPackAdd() {
        this.sendAllPack.incrementAndGet();
    }

    @After(value="execution(* com.dfssi.access.common.listener.PackCodecListener.newPackDecoder())")
    public void connAdd() {
        this.connTotal.incrementAndGet();
    }

    @Around(value="execution(* com.dfssi.access.common.listener.MsgCodecListener.decode(*,*))")
    public Object receivePackAdd(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            Object object = joinPoint.proceed();
            if (object == null) {
                this.waitHandleMsg.decrementAndGet();
            }
            return object;
        }
        catch (Throwable throwable) {
            this.waitHandleMsg.decrementAndGet();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* com.dfssi.access.common.listener.MsgHandlerListener.handlerReceiveMsg(..))")
    public void receiveMsgAdd(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            long maxHandleTime = 500L;
            long startTime = System.currentTimeMillis();
            joinPoint.proceed();
            if (System.currentTimeMillis() - startTime > maxHandleTime) {
                TcpConnection conn = (TcpConnection)joinPoint.getArgs()[1];
                TcpProtoMsg upMsg = (TcpProtoMsg)joinPoint.getArgs()[2];
                MethodInvoker methodInvoker = this.methodAdapter.getUpMethodInvoker(conn, upMsg.id);
                conn.info("\u4e0a\u884c\u6d88\u606f[{}]\u5904\u7406\u65b9\u6cd5[{}:{}]\u6267\u884c\u8017\u65f6\u5df2\u8d85\u8fc7{}\u6beb\u79d2,\u8bf7\u6ce8\u610f\u4f18\u5316\u4ee3\u7801", upMsg.getId(), methodInvoker.getBean().getClass(), methodInvoker.getMethod().getName(), maxHandleTime);
            }
        }
        finally {
            this.waitHandleMsg.decrementAndGet();
            this.handleAllMsg.incrementAndGet();
        }
    }

    @After(value="execution(* com.dfssi.access.common.listener.MsgHandlerListener.sendListenerMsg(..))")
    public void listenerMsgAdd() {
        this.commandCount.incrementAndGet();
    }

    @AfterReturning(pointcut="execution(* com.dfssi.access.common.listener.MsgHandlerListener.handlerReplyMsg(..))", returning="b")
    public void replyMsgAdd(boolean b) {
        if (b) {
            this.replyCount.incrementAndGet();
        }
    }
}

