/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.remote;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.codec.MarshallCodec;
import com.dfssi.access.common.exception.RemoteException;
import com.dfssi.access.common.listener.RemoteCallListener;
import com.dfssi.access.common.message.MethodInvokeMeta;
import com.dfssi.access.common.message.MethodReturnMeta;
import com.dfssi.access.common.remote.RemoteResult;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;

public class ServerCallMaster
implements RemoteCallListener {
    @Autowired
    private AccessProperties properties;
    @Autowired
    private EventLoopGroup eventLoopGroup;

    @Override
    public Object remoteInvoke(MethodInvokeMeta methodInvokeMeta) throws Throwable {
        final RemoteResult remoteResult = new RemoteResult();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{MarshallCodec.buildDecoder(), MarshallCodec.buildEncoder(), new SimpleChannelInboundHandler<MethodReturnMeta>(){

                    protected void channelRead0(ChannelHandlerContext ctx, MethodReturnMeta returnMeta) {
                        remoteResult.setResult(returnMeta.returnObj);
                    }
                }});
            }
        });
        return this.msgToMaster(bootstrap, remoteResult, methodInvokeMeta);
    }

    private Object msgToMaster(Bootstrap bootstrap, RemoteResult remoteResult, MethodInvokeMeta methodInvokeMeta) throws Throwable {
        bootstrap.connect(this.properties.getMaster().getIp(), this.properties.getMaster().getPort()).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                f.channel().writeAndFlush((Object)methodInvokeMeta).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (!future.isSuccess()) {
                        future.channel().close();
                        remoteResult.setResult(new RemoteException("\u8fdc\u7a0b\u8c03\u7528\u6d88\u606f\u53d1\u9001\u5931\u8d25"));
                    }
                }));
            } else {
                remoteResult.setResult(new RemoteException("Master\u8fde\u63a5\u5931\u8d25"));
            }
        }));
        try {
            return remoteResult.waitResult(methodInvokeMeta.timeout);
        }
        catch (TimeoutException e) {
            if (methodInvokeMeta.needRetry()) {
                remoteResult.release();
                return this.msgToMaster(bootstrap, remoteResult, methodInvokeMeta);
            }
            throw e;
        }
    }
}

