/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.remote;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public class InterfacesScanner
extends ClassPathBeanDefinitionScanner {
    public final Class<? extends AbstractFactoryBean<?>> factoryBeanClass;

    public InterfacesScanner(BeanDefinitionRegistry registry, Class<? extends AbstractFactoryBean<?>> factoryBeanClass) {
        super(registry, false);
        this.factoryBeanClass = factoryBeanClass;
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        this.addIncludeFilter((metadataReader, metadataReaderFactory) -> true);
        Set beanDefinitionHolders = super.doScan(basePackages);
        Assert.notEmpty((Collection)beanDefinitionHolders, (String)"basePackages\u5305\u4e2d\u6ca1\u6709\u63a5\u53e3\u7c7b");
        for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
            GenericBeanDefinition beanDefinition = (GenericBeanDefinition)beanDefinitionHolder.getBeanDefinition();
            ConstructorArgumentValues constructorArgumentValues = beanDefinition.getConstructorArgumentValues();
            constructorArgumentValues.addGenericArgumentValue((Object)Objects.requireNonNull(beanDefinition.getBeanClassName()));
            beanDefinition.setBeanClass(this.factoryBeanClass);
            beanDefinition.setAutowireMode(2);
        }
        return beanDefinitionHolders;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        return metadata.isInterface() && metadata.isIndependent();
    }
}

