/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.monitor;

import com.alibaba.fastjson.JSONArray;
import com.dfssi.access.common.monitor.MonitorServer;
import com.dfssi.access.common.server.ServerAspect;
import com.dfssi.access.common.server.ServerConnHandler;
import com.dfssi.access.common.tcp.TcpConnection;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;

public class MonitorServerImpl
implements MonitorServer {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    @Autowired
    private ServerAspect serverAspect;
    @Autowired
    private ServerConnHandler serverConnHandler;

    @Override
    public Map<String, Long> getAspectInfo(String connName) throws Exception {
        Field[] declaredFields;
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Field field : declaredFields = ServerAspect.class.getDeclaredFields()) {
            if (field.getType() != AtomicLong.class) continue;
            field.setAccessible(true);
            AtomicLong atomicLong = (AtomicLong)field.get(this.serverAspect);
            map.put(field.getName(), atomicLong.get());
        }
        return map;
    }

    @Override
    public List<Object> getConnInfo(String connName) {
        JSONArray jsonArray = new JSONArray();
        for (TcpConnection tcpConnection : this.serverConnHandler.getUnAuthConnections()) {
            jsonArray.add((Object)tcpConnection.toJson(this.formatter));
        }
        for (Map.Entry entry : this.serverConnHandler.getAuthConnections().entrySet()) {
            TcpConnection connection = (TcpConnection)entry.getValue();
            jsonArray.add((Object)connection.toJson(this.formatter));
        }
        return jsonArray;
    }

    @Override
    public Serializable getAuthInfo(String connName, String commandKey) {
        TcpConnection connection = this.serverConnHandler.getAuthConnections().get(commandKey);
        return connection == null ? null : connection.getEntity();
    }
}

