/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.message;

import com.dfssi.access.common.annotation.RemoteAsync;
import com.dfssi.access.common.annotation.RemoteParam;
import com.dfssi.access.common.message.ReturnMsg;
import java.lang.reflect.Method;
import java.util.UUID;

public class MethodInvokeMeta
extends ReturnMsg {
    public final Class<?> interfaceClass;
    public final String methodName;
    public final Object[] args;
    public final Class<?>[] parameterTypes;
    private int retryCount;
    public final int timeout;
    public final boolean async;

    public MethodInvokeMeta(Class<?> interfaceClass, Method method, Object[] args) {
        this.returnKey = UUID.randomUUID().toString();
        this.interfaceClass = interfaceClass;
        this.args = args;
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        RemoteParam remoteParam = method.getAnnotation(RemoteParam.class);
        this.timeout = remoteParam != null ? (remoteParam.timeout() > 1 ? remoteParam.timeout() : 10) : 10;
        this.retryCount = remoteParam != null ? remoteParam.retry() : 0;
        this.async = method.isAnnotationPresent(RemoteAsync.class);
    }

    public boolean needRetry() {
        if (this.retryCount > 0) {
            --this.retryCount;
            this.returnKey = UUID.randomUUID().toString();
            return true;
        }
        return false;
    }
}

