/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.master;

import com.dfssi.access.common.exception.RemoteException;
import com.dfssi.access.common.master.MasterConnection;
import com.dfssi.access.common.message.ConnOccupation;
import com.dfssi.access.common.message.MethodInvokeMeta;
import com.dfssi.access.common.message.MethodReturnMeta;
import com.dfssi.access.common.message.ServerInfo;
import com.dfssi.access.common.remote.RemoteResult;
import com.dfssi.access.common.remote.VoidResult;
import com.dfssi.access.common.util.Connection;
import com.google.common.collect.Maps;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ChannelHandler.Sharable
public class MasterServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MasterServerHandler.class);
    private final AttributeKey<MasterConnection> attrConn = AttributeKey.newInstance((String)"connection");
    private final Map<String, MasterConnection> connMap = Maps.newConcurrentMap();
    private final Map<String, RemoteResult> resultMap = Maps.newConcurrentMap();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ApplicationContext context;
    private final int idleTimeout;
    @Autowired(required=false)
    private ConnListener connListener;

    public Object channelWrite(MethodInvokeMeta meta, Channel channel) throws Throwable {
        RemoteResult remoteResult = new RemoteResult();
        channel.writeAndFlush((Object)meta).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                this.resultMap.put(methodInvokeMeta.returnKey, remoteResult);
            } else {
                remoteResult.setResult(new RemoteException("client\u6d88\u606f\u53d1\u9001\u5931\u8d25", f.cause()));
            }
        }));
        try {
            Object object = remoteResult.waitResult(meta.timeout);
            return object;
        }
        catch (TimeoutException e) {
            if (meta.needRetry()) {
                Object object = this.channelWrite(meta, channel);
                return object;
            }
            throw e;
        }
        finally {
            this.resultMap.remove(meta.returnKey);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block11: {
            if (msg instanceof ServerInfo) {
                this.putConnection(ctx.channel(), (ServerInfo)msg);
            } else if (msg instanceof MethodReturnMeta) {
                MethodReturnMeta methodReturnMeta = (MethodReturnMeta)msg;
                RemoteResult remoteResult = this.resultMap.get(methodReturnMeta.returnKey);
                if (remoteResult != null) {
                    remoteResult.setResult(methodReturnMeta.returnObj);
                }
            } else if (msg instanceof MethodInvokeMeta) {
                MethodInvokeMeta invokeMeta = (MethodInvokeMeta)msg;
                try {
                    Object targetObject = this.context.getBean(invokeMeta.interfaceClass);
                    if (invokeMeta.async) {
                        ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, new VoidResult())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                    Method method = targetObject.getClass().getMethod(invokeMeta.methodName, invokeMeta.parameterTypes);
                    Object obj = method.invoke(targetObject, invokeMeta.args);
                    if (!invokeMeta.async) {
                        ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, obj == null ? new VoidResult() : obj)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                }
                catch (BeansException e) {
                    log.error("\u8bf7\u5b9e\u73b0\u63a5\u53e3\u7c7b" + invokeMeta.interfaceClass, (Throwable)e);
                    ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, (Object)e)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                catch (Exception e) {
                    log.error("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38", (Throwable)e);
                    if (invokeMeta.async) break block11;
                    ctx.writeAndFlush((Object)new MethodReturnMeta(invokeMeta.returnKey, e)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
        }
    }

    private void putConnection(Channel channel, ServerInfo serverInfo) {
        Attribute attr = channel.attr(this.attrConn);
        MasterConnection conn = (MasterConnection)attr.get();
        if (conn != null) {
            return;
        }
        if (this.connMap.containsKey(serverInfo.getConnKey())) {
            conn = this.connMap.get(serverInfo.getConnKey());
            channel.writeAndFlush((Object)new ConnOccupation(conn.remoteHost, conn.remotePort));
            return;
        }
        conn = new MasterConnection(channel, serverInfo);
        attr.set((Object)conn);
        this.connMap.put(serverInfo.getConnKey(), conn);
        conn.info("\u52a0\u5165\u8fde\u63a5,\u5f53\u524dTcp\u8fde\u63a5\u6570:{}", this.connMap.size());
        if (this.connListener != null) {
            MasterConnection connection = conn;
            this.executorService.submit(() -> this.connListener.connect(connection));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        MasterConnection conn = (MasterConnection)ctx.channel().attr(this.attrConn).get();
        if (conn != null && conn == this.connMap.get(conn.serverInfo.getConnKey())) {
            this.connMap.remove(conn.serverInfo.getConnKey());
            conn.info("\u88ab\u79fb\u9664,\u5f53\u524dTcp\u8fde\u63a5\u6570:{}", this.connMap.size());
            if (this.connListener != null) {
                this.executorService.submit(() -> this.connListener.disconnect(conn));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Connection conn = (Connection)ctx.channel().attr(this.attrConn).get();
        if (conn != null) {
            conn.error(cause);
        } else {
            log.error("\u6d88\u606f\u5904\u7406\u5f02\u5e38", cause);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            Connection conn = (Connection)ctx.channel().attr(this.attrConn).get();
            if (conn == null) {
                ctx.close();
            } else {
                conn.close(this.idleTimeout * 2 + "\u79d2\u5185\u672a\u6536\u5230\u5fc3\u8df3\uff0c\u88ab\u5e73\u53f0\u5173\u95ed\u8fde\u63a5");
            }
        }
    }

    public MasterServerHandler(ApplicationContext context, int idleTimeout) {
        this.context = context;
        this.idleTimeout = idleTimeout;
    }

    public Map<String, MasterConnection> getConnMap() {
        return this.connMap;
    }

    public static interface ConnListener {
        public void connect(MasterConnection var1);

        public void disconnect(MasterConnection var1);
    }
}

