/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.master;

import com.alibaba.fastjson.JSONObject;
import com.dfssi.access.common.message.ServerInfo;
import com.dfssi.access.common.util.Connection;
import io.netty.channel.Channel;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class MasterConnection
extends Connection {
    public final ServerInfo serverInfo;

    public MasterConnection(Channel channel, ServerInfo serverInfo) {
        super(channel);
        this.serverInfo = serverInfo;
    }

    @Override
    public String desc() {
        return "[" + this.remoteHost + ":" + this.remotePort + "][" + this.serverInfo.getConnKey() + "] ";
    }

    public JSONObject toJson(DateTimeFormatter formatter) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ip", (Object)this.remoteHost);
        jsonObject.put("time", (Object)formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.serverInfo.getConnTime()), ZoneId.systemDefault())));
        jsonObject.put("connKey", (Object)this.serverInfo.getConnKey());
        jsonObject.put("agreement", (Object)this.serverInfo.getAgreement().name());
        jsonObject.put("port", (Object)this.serverInfo.getPort());
        jsonObject.put("monitor", (Object)this.serverInfo.isEnableMonitor());
        return jsonObject;
    }
}

