/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.codec;

import com.dfssi.access.common.codec.PackDecoder;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.listener.PackCodecListener;
import com.dfssi.access.common.listener.ProtoPackListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.util.ProtoUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;

@ChannelHandler.Sharable
public class Pack2PackCodec
extends MessageToMessageCodec<ByteBuf, ByteBuf> {
    private final ProtoPackListener packListener;
    private final PackCodecListener codecListener;

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, List<Object> list) {
        ByteBuf out = this.codecListener.encode(in);
        list.add(out);
        this.logProto((TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get(), false, out);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> list) throws Exception {
        Channel channel = ctx.channel();
        TcpConnection connection = (TcpConnection)channel.attr(ProtoUtil.CONN_KEY).get();
        this.logProto(connection, true, in);
        this.codecListener.decode((PackDecoder)channel.attr(ProtoUtil.DECODER_KEY).get(), in, list);
        if (list.isEmpty() && connection.notRecvMsg()) {
            throw new CodecException(ErrorCode.NOT_FIND_AGREEMENT, "\u672a\u6536\u5230\u6b63\u786e\u7684\u5305");
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(ProtoUtil.DECODER_KEY).set((Object)this.codecListener.newPackDecoder());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ((PackDecoder)ctx.channel().attr(ProtoUtil.DECODER_KEY).get()).release();
        super.channelInactive(ctx);
    }

    private void logProto(TcpConnection connection, boolean up, ByteBuf protoBuf) {
        if (this.packListener != null) {
            String msgStr = ProtoUtil.wholeStrWithSpace(protoBuf);
            if (up) {
                this.packListener.receive(connection, msgStr);
            } else {
                this.packListener.send(connection, msgStr);
            }
        } else {
            connection.debug("{} {}", up ? "recv" : "send", ProtoUtil.wholeStrWithSpace(protoBuf));
        }
    }

    public Pack2PackCodec(ProtoPackListener packListener, PackCodecListener codecListener) {
        this.packListener = packListener;
        this.codecListener = codecListener;
    }
}

