/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.codec;

import com.dfssi.access.common.codec.MethodAdapter;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.listener.ProtoMsgListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.Connection;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.util.XyMsg;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

@ChannelHandler.Sharable
public class Pack2MsgCodec
extends MessageToMessageCodec<ByteBuf, XyMsg> {
    private final ProtoMsgListener msgListener;
    private final MsgCodecListener codecListener;
    private final MethodAdapter methodAdapter;
    private final Class<? extends TcpProtoMsg> msgClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void encode(ChannelHandlerContext ctx, XyMsg xyMsg, List<Object> list) throws Exception {
        TcpConnection connection = (TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get();
        TcpProtoMsg downMsg = null;
        try {
            if (this.msgClass.isAssignableFrom(xyMsg.getClass())) {
                downMsg = (TcpProtoMsg)xyMsg;
                connection.fillDownMsg(downMsg);
            } else {
                downMsg = this.methodAdapter.processDownMsg(connection, xyMsg, this.msgClass);
            }
            this.codecListener.encode(downMsg, list);
        }
        finally {
            if (downMsg != null) {
                downMsg.release();
            }
        }
        if (downMsg == null) {
            return;
        }
        connection.incSendCount();
        if (this.msgListener != null) {
            for (Object o : list) {
                downMsg.dataBuf = (ByteBuf)o;
                this.msgListener.send(connection, downMsg);
            }
        }
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        TcpProtoMsg upMsg = this.codecListener.decode(ctx, byteBuf, this.msgClass);
        if (upMsg == null) {
            return;
        }
        if (this.msgListener != null) {
            this.msgListener.receive((Connection)ctx.channel().attr(ProtoUtil.CONN_KEY).get(), upMsg);
        }
        if (upMsg.dataBuf == byteBuf) {
            byteBuf.retain();
        }
        list.add(upMsg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        TcpConnection connection = (TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get();
        if (throwable instanceof IOException) {
            String message = throwable.getMessage();
            if (message.startsWith("\u8fdc\u7a0b\u4e3b\u673a\u5f3a\u8feb\u5173\u95ed")) {
                connection.close("\u5f3a\u5236\u5173\u95ed\u4e86\u8fde\u63a5");
            } else {
                connection.error(throwable);
            }
        } else {
            Throwable cause = throwable.getCause();
            if (cause instanceof CodecException) {
                connection.incErrorCount(cause.getMessage());
            } else {
                connection.error(cause instanceof InvocationTargetException ? cause.getCause() : cause);
            }
        }
    }

    public Pack2MsgCodec(ProtoMsgListener msgListener, MsgCodecListener codecListener, MethodAdapter methodAdapter, Class<? extends TcpProtoMsg> msgClass) {
        this.msgListener = msgListener;
        this.codecListener = codecListener;
        this.methodAdapter = methodAdapter;
        this.msgClass = msgClass;
    }
}

