/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.codec;

import com.dfssi.access.common.annotation.DownMsg;
import com.dfssi.access.common.annotation.UpMsg;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvoker {
    private final Object bean;
    private final Method method;
    private final Class<?>[] params;
    private final boolean unique;

    private MethodInvoker(Object bean, Method method, Class<?>[] params, boolean unique) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        this.bean = bean;
        this.method = method;
        this.params = params;
        this.unique = unique;
    }

    public Object invoke(TcpConnection connection, Object entity) throws InvocationTargetException, IllegalAccessException {
        Object[] objects = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].isAssignableFrom(connection.getClass())) {
                objects[i] = connection;
                continue;
            }
            if (this.params[i].isAssignableFrom(entity.getClass())) {
                objects[i] = entity;
                continue;
            }
            if (ByteBuf.class == this.params[i] && entity instanceof TcpProtoMsg) {
                objects[i] = ((TcpProtoMsg)entity).dataBuf;
                continue;
            }
            if (connection.isAuth() && this.params[i].isAssignableFrom(connection.getEntity().getClass())) {
                objects[i] = connection.getEntity();
                continue;
            }
            if (Channel.class == this.params[i]) {
                objects[i] = connection.channel;
                continue;
            }
            if (EventLoop.class != this.params[i]) continue;
            objects[i] = connection.channel.eventLoop();
        }
        return this.method.invoke(this.bean, objects);
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public static class Down
    extends MethodInvoker {
        private final DownMsg downMsg;

        public Down(Object bean, Method method, Class<?>[] params, boolean unique, DownMsg downMsg) {
            super(bean, method, params, unique);
            this.downMsg = downMsg;
        }

        public DownMsg getDownMsg() {
            return this.downMsg;
        }
    }

    public static class Up
    extends MethodInvoker {
        private final UpMsg upMsg;

        public Up(Object bean, Method method, Class<?>[] params, boolean unique, UpMsg upMsg) {
            super(bean, method, params, unique);
            this.upMsg = upMsg;
        }

        public UpMsg getUpMsg() {
            return this.upMsg;
        }
    }
}

