/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.client;

import com.dfssi.access.common.client.Client;
import com.dfssi.access.common.client.ClientConnHandler;
import com.dfssi.access.common.exception.ClientException;
import com.dfssi.access.common.tcp.TcpListenerMsg;
import com.dfssi.access.common.util.XyMsg;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@ConditionalOnBean(value={Client.class})
@Component
@Aspect
public class ClientAspect
implements ApplicationListener<ApplicationReadyEvent> {
    private final Map<Client, ClientConnHandler> connHandlerMap = new HashMap<Client, ClientConnHandler>();

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        ConfigurableApplicationContext applicationContext = applicationReadyEvent.getApplicationContext();
        for (Map.Entry entry : applicationContext.getBeansOfType(Client.class).entrySet()) {
            try {
                Client client = (Client)entry.getValue();
                ClientConnHandler clientConnHandler = new ClientConnHandler((ApplicationContext)applicationContext, client);
                this.connHandlerMap.put(client, clientConnHandler);
                clientConnHandler.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Around(value="execution(* com.dfssi.access.common.client.Client.sendMsg(com.dfssi.access.common.util.XyMsg))")
    public void clientSendMsg(ProceedingJoinPoint joinPoint) throws ClientException {
        Client target = (Client)joinPoint.getTarget();
        ClientConnHandler clientConnHandler = this.connHandlerMap.get(target);
        clientConnHandler.sendMsg((XyMsg)joinPoint.getArgs()[0]);
    }

    @Around(value="execution(* com.dfssi.access.common.client.Client.sendListenerMsg(com.dfssi.access.common.listener.MsgHandlerListener.Msg))")
    public void clientSendListenerMsg(ProceedingJoinPoint joinPoint) throws ClientException {
        Client target = (Client)joinPoint.getTarget();
        ClientConnHandler clientConnHandler = this.connHandlerMap.get(target);
        clientConnHandler.sendListenerMsg((TcpListenerMsg)joinPoint.getArgs()[0]);
    }

    @PreDestroy
    public void destroy() {
        for (ClientConnHandler value : this.connHandlerMap.values()) {
            value.stop();
        }
    }
}

