/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common._808;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common._808.Msg8003;
import com.dfssi.access.common._808.Msg8800;
import com.dfssi.access.common._808._808Msg;
import com.dfssi.access.common.util.XyMsg;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _808PackSplicer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(_808PackSplicer.class);
    private static final AtomicIntegerFieldUpdater<_808PackSplicer> retryDecCount = AtomicIntegerFieldUpdater.newUpdater(_808PackSplicer.class, "retryCount");
    private volatile int retryCount;
    private static final AtomicIntegerFieldUpdater<_808PackSplicer> packDecCount = AtomicIntegerFieldUpdater.newUpdater(_808PackSplicer.class, "packCount");
    private volatile int packCount;
    private final byte[][] bytes;
    private final _808Msg protoMsg;
    private final Channel channel;
    private final int onePackReceiveTime;
    private volatile ScheduledFuture<?> future;

    public _808PackSplicer(_808Msg protoMsg, Channel channel, AccessProperties.Xy808 properties) {
        this.bytes = new byte[protoMsg.packCount][];
        this.protoMsg = protoMsg;
        this.channel = channel;
        this.onePackReceiveTime = properties.getOnePackReceiveTime();
        retryDecCount.set(this, properties.getRetryCount());
        packDecCount.set(this, protoMsg.packCount);
        long delayTime = this.onePackReceiveTime * (protoMsg.packCount - 1);
        log.debug("[{}]\u79d2\u540e\u68c0\u67e5\u5206\u5305[{}:{}:{}]\u662f\u5426\u5168\u90e8\u6536\u5230", new Object[]{delayTime, protoMsg.msgKey(), protoMsg.getId(), protoMsg.packCount});
        this.future = channel.eventLoop().schedule((Runnable)this, delayTime, TimeUnit.SECONDS);
    }

    public ByteBuf addSplitPack(int packIndex, ByteBuf pack) {
        log.debug("\u63a5\u6536\u5230\u5206\u5305\u6570\u636e\uff1amsgKey=[{}],msgId=[{}],packCount=[{}],packIndex=[{}]", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount, packIndex});
        int byteIndex = packIndex - 1;
        byte[][] bytes = this.bytes;
        if (bytes[byteIndex] == null) {
            bytes[byteIndex] = new byte[pack.readableBytes()];
            pack.readBytes(bytes[byteIndex]);
            if (packDecCount.decrementAndGet(this) == 0) {
                this.future.cancel(true);
                log.debug("\u5206\u5305[{}:{}:{}]\u5df2\u5168\u90e8\u6536\u5230\uff0c\u53d6\u6d88\u68c0\u67e5\u4efb\u52a1", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount});
                return Unpooled.wrappedBuffer((int)bytes.length, (byte[][])bytes);
            }
        }
        return null;
    }

    @Override
    public void run() {
        Attribute attribute = this.channel.attr(AttributeKey.valueOf((String)(this.protoMsg.getId() + "_" + this.protoMsg.getSn())));
        if (attribute.get() == null) {
            log.debug("\u5206\u5305[{}:{}:{}]\u7f13\u5b58\u5df2\u88ab\u6e05\u9664", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount});
            return;
        }
        if (retryDecCount.getAndDecrement(this) <= 0) {
            log.debug("\u5206\u5305[{}:{}:{}]\u672a\u5168\u90e8\u6536\u5230\uff0c\u91cd\u8bd5\u6b21\u6570\u5df2\u7528\u5c3d\u6e05\u9664\u7f13\u5b58", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount});
            attribute.set(null);
            return;
        }
        List<Integer> lackIndex = this.getLackIndex();
        Object replyMsg = this.getReplyObject(lackIndex);
        if (replyMsg == null) {
            attribute.set(null);
            return;
        }
        int lackCount = lackIndex.size();
        if (this.channel.isActive()) {
            this.channel.writeAndFlush((Object)XyMsg.create(this.protoMsg.key, replyMsg)).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                if (f.isSuccess()) {
                    long delayTime = lackCount * this.onePackReceiveTime;
                    log.debug("\u5206\u5305[{}:{}:{}]\u5269\u4f59[{}]\u4e2a\u5305\u672a\u6536\u5230\uff0c\u53d1\u9001\u5206\u5305\u8865\u4f20\u6d88\u606f,{}\u540e\u79d2\u518d\u6b21\u68c0\u67e5", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount, lackCount, delayTime});
                    this.future = this.channel.eventLoop().schedule((Runnable)this, delayTime, TimeUnit.SECONDS);
                } else {
                    log.warn("\u5206\u5305[{}:{}:{}]\u5269\u4f59[{}]\u4e2a\u5305\u672a\u6536\u5230\uff0c\u5206\u5305\u8865\u4f20\u6d88\u606f\u53d1\u9001\u5931\u8d25\u6e05\u9664\u7f13\u5b58", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount, lackCount});
                    attribute.set(null);
                }
            }));
        } else {
            log.warn("\u5206\u5305[{}:{}:{}]\u5269\u4f59[{}]\u4e2a\u5305\u672a\u6536\u5230\uff0c\u8fde\u63a5\u5df2\u88ab\u5173\u95ed\u6e05\u9664\u7f13\u5b58", new Object[]{this.protoMsg.msgKey(), this.protoMsg.getId(), this.protoMsg.packCount, lackCount});
            attribute.set(null);
        }
    }

    private List<Integer> getLackIndex() {
        ArrayList list = Lists.newArrayList();
        byte[][] bytes = this.bytes;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != null) continue;
            list.add(i + 1);
        }
        return list;
    }

    private Object getReplyObject(List<Integer> lackIndex) {
        if (lackIndex.isEmpty()) {
            return null;
        }
        if (this.protoMsg.id == 2049) {
            byte[][] bytes = this.bytes;
            if (bytes[0] == null || bytes[0].length < 4) {
                return null;
            }
            Msg8800 msg8800 = new Msg8800();
            msg8800.setMediaId(this.byte2Int(bytes[0]));
            msg8800.setPackIndex(lackIndex);
            return msg8800;
        }
        Msg8003 msg8003 = new Msg8003();
        msg8003.setSn(this.protoMsg.sn);
        msg8003.setPackIndex(lackIndex);
        return msg8003;
    }

    private int byte2Int(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }
}

