/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common._808;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common._808.Msg8001;
import com.dfssi.access.common._808._808Msg;
import com.dfssi.access.common._808._808PackSplicer;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.util.XyMsg;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;

public class _808MsgCodec
implements MsgCodecListener {
    private final int DECRYPT_INDEX = 10;
    private final int SPLIT_INDEX = 13;
    private final int NEWXY_INDEX = 14;
    private AccessProperties.Xy808 properties;

    @Override
    public void initProperties(AccessProperties accessProperties) {
        this.properties = accessProperties.getXy808();
    }

    @Override
    public void encode(TcpProtoMsg protoMsg, List<Object> list) {
        _808Msg downMsg = (_808Msg)protoMsg;
        int dataLen = downMsg.dataBuf == null ? 0 : downMsg.dataBuf.readableBytes();
        boolean newXy = downMsg.isNewXy();
        if (downMsg.packCount == 1) {
            ByteBuf outBuf = this.writeMsg(downMsg, downMsg.sn, dataLen, false, newXy);
            if (dataLen > 0) {
                outBuf.writeBytes(downMsg.dataBuf);
            }
            list.add(outBuf);
        } else {
            int sn = downMsg.sn;
            int packSize = dataLen / downMsg.packCount;
            for (int packIndex = 1; packIndex <= downMsg.packCount; ++packIndex) {
                if (packIndex == downMsg.packCount) {
                    packSize += dataLen % downMsg.packCount;
                }
                ByteBuf outBuf = this.writeMsg(downMsg, sn, packSize, true, newXy);
                outBuf.writeShort(downMsg.packCount);
                outBuf.writeShort(packIndex);
                outBuf.writeBytes(downMsg.dataBuf, packSize);
                list.add(outBuf);
                ++sn;
            }
        }
    }

    private ByteBuf writeMsg(_808Msg protoMsg, int sn, int packSize, boolean split, boolean newXy) {
        int headLen = newXy ? 17 : 12;
        ByteBuf outBuf = Unpooled.buffer((int)(packSize + (split ? headLen + 4 : headLen)));
        outBuf.writeShort(protoMsg.id);
        int prop = packSize & 0x3FF;
        if (newXy) {
            prop = ProtoUtil.setBitOne(prop, 14);
        }
        if (protoMsg.secrecy) {
            prop = ProtoUtil.setBitOne(prop, 10);
        }
        if (split) {
            prop = ProtoUtil.setBitOne(prop, 13);
        }
        outBuf.writeShort(prop);
        if (newXy) {
            outBuf.writeByte((int)protoMsg.version.shortValue());
        }
        protoMsg.writeKey(outBuf);
        outBuf.writeShort(sn);
        return outBuf;
    }

    @Override
    public _808Msg decode(ChannelHandlerContext ctx, ByteBuf byteBuf, Class<? extends TcpProtoMsg> msgClass) throws Exception {
        Channel channel;
        Attribute attribute;
        _808PackSplicer packSplicer;
        _808Msg protoMsg = (_808Msg)msgClass.newInstance();
        protoMsg.id = byteBuf.readUnsignedShort();
        short prop = byteBuf.readShort();
        if (this.properties.isNewXy() && ProtoUtil.isBitOne(prop, 14)) {
            protoMsg.version = byteBuf.readUnsignedByte();
        }
        protoMsg.key = protoMsg.readKey(byteBuf);
        int currentSn = byteBuf.readUnsignedShort();
        boolean split = ProtoUtil.isBitOne(prop, 13);
        int dataLen = prop & 0x3FF;
        int bodyLen = byteBuf.readableBytes() - (split ? 4 : 0);
        if (dataLen != bodyLen) {
            throw new CodecException(ErrorCode.LEN_CHECK_FAILURE, "\u6d88\u606f\u5934\u8bfb\u53d6\u957f\u5ea6[" + dataLen + "]\u4e0d\u7b49\u4e8e\u6d88\u606f\u4f53\u5b9e\u9645\u957f\u5ea6[" + bodyLen + "]");
        }
        protoMsg.secrecy = ProtoUtil.isBitOne(prop, 10);
        if (!split) {
            protoMsg.sn = currentSn;
            protoMsg.dataBuf = byteBuf;
            return protoMsg;
        }
        protoMsg.packCount = byteBuf.readUnsignedShort();
        int packIndex = byteBuf.readUnsignedShort();
        if (packIndex <= 0 || packIndex > protoMsg.packCount) {
            throw new CodecException(ErrorCode.SPLIT_INDEX_ERROR, "\u5206\u5305\u7d22\u5f15\u53f7\u9519\u8bef: packCount=" + protoMsg.packCount + ",packIndex=" + packIndex);
        }
        protoMsg.sn = currentSn - (packIndex - 1);
        if (protoMsg.sn < 0) {
            protoMsg.sn += 65536;
        }
        if ((packSplicer = (_808PackSplicer)(attribute = (channel = ctx.channel()).attr(AttributeKey.valueOf((String)(protoMsg.getId() + "_" + protoMsg.getSn())))).get()) == null) {
            packSplicer = new _808PackSplicer(protoMsg, channel, this.properties);
            attribute.set((Object)packSplicer);
        }
        protoMsg.dataBuf = packSplicer.addSplitPack(packIndex, byteBuf);
        if (protoMsg.dataBuf != null) {
            attribute.set(null);
            return protoMsg;
        }
        Msg8001 msg8001 = new Msg8001();
        msg8001.setMsgId(protoMsg.id);
        msg8001.setSn(currentSn);
        msg8001.setRc((byte)0);
        ctx.writeAndFlush((Object)XyMsg.create(protoMsg.key, msg8001));
        return null;
    }
}

