/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common._808._808MsgProcess;
import com.dfssi.access.common.client.ClientAspect;
import com.dfssi.access.common.codec.Agreement;
import com.dfssi.access.common.codec.MethodAdapter;
import com.dfssi.access.common.codec.MsgHandlerAdapter;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.listener.MsgHandlerListener;
import com.dfssi.access.common.listener.PackCodecListener;
import com.dfssi.access.common.monitor.MonitorHttpHandler;
import com.dfssi.access.common.monitor.MonitorServer;
import com.dfssi.access.common.monitor.MonitorServerImpl;
import com.dfssi.access.common.server.ServerAspect;
import com.dfssi.access.common.server.ServerConnHandler;
import com.dfssi.access.common.server.ServerMasterRunner;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan(basePackageClasses={_808MsgProcess.class, ClientAspect.class})
@Configuration
@EnableConfigurationProperties(value={AccessProperties.class})
public class AccessConfiguration {
    @ConditionalOnMissingBean(value={EventLoopGroup.class})
    @Bean(destroyMethod="shutdownGracefully")
    public EventLoopGroup eventLoopGroup(AccessProperties accessProperties) {
        return new NioEventLoopGroup(accessProperties.getThreadCount());
    }

    @Bean
    public MethodAdapter methodAdapter() {
        return new MethodAdapter();
    }

    @ConditionalOnProperty(name={"spring.master.connName"})
    @Bean
    public ServerMasterRunner serverMasterRunner() {
        return new ServerMasterRunner();
    }

    @ConditionalOnMissingBean(value={MsgHandlerListener.class})
    @Bean
    public MsgHandlerListener msgHandlerListener() {
        return new MsgHandlerAdapter();
    }

    @ConditionalOnProperty(name={"spring.server.agreement"})
    @Bean
    public PackCodecListener packCodecListener(AccessProperties accessProperties) throws IllegalAccessException, InstantiationException {
        Agreement agreement = accessProperties.getServer().getAgreement();
        return agreement.getPackCodecClass().newInstance();
    }

    @ConditionalOnProperty(name={"spring.server.agreement"})
    @Bean
    public MsgCodecListener msgCodecListener(AccessProperties accessProperties) throws IllegalAccessException, InstantiationException {
        Agreement agreement = accessProperties.getServer().getAgreement();
        MsgCodecListener codecListener = agreement.getMsgCodecClass().newInstance();
        codecListener.initProperties(accessProperties);
        return codecListener;
    }

    @ConditionalOnProperty(name={"spring.server.agreement"})
    @Bean
    public ServerConnHandler serverConnHandler(EventLoopGroup eventLoopGroup, AccessProperties accessProperties) {
        return new ServerConnHandler(eventLoopGroup, accessProperties.getServer());
    }

    @ConditionalOnProperty(name={"spring.server.enableMonitor"}, havingValue="true")
    @Bean
    public ServerAspect serverAspect() {
        return new ServerAspect();
    }

    @ConditionalOnProperty(name={"spring.server.enableMonitor"}, havingValue="true")
    @Bean
    public MonitorServer monitorServer() {
        return new MonitorServerImpl();
    }

    @ConditionalOnMissingBean(value={ServerMasterRunner.class})
    @ConditionalOnProperty(name={"spring.server.enableMonitor"}, havingValue="true")
    @Bean
    public MonitorHttpHandler monitorHttpHandler(EventLoopGroup eventLoopGroup, AccessProperties accessProperties, MonitorServer monitorServer) {
        return new MonitorHttpHandler(eventLoopGroup, accessProperties.getServer().getMonitorPort(), monitorServer);
    }
}

