/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_wqg6;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.xy_wqg6.Wqg6Msg;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;

public class Wqg6MsgCodec
implements MsgCodecListener {
    @Override
    public void initProperties(AccessProperties accessProperties) {
    }

    @Override
    public void encode(TcpProtoMsg downMsg, List<Object> list) {
        Wqg6Msg protoMsg = (Wqg6Msg)downMsg;
        int dataLen = protoMsg.dataBuf == null ? 0 : protoMsg.dataBuf.readableBytes();
        ByteBuf outBuf = Unpooled.buffer((int)(dataLen + 28));
        outBuf.writeByte(protoMsg.id);
        int len = ProtoUtil.writeString(outBuf, protoMsg.msgKey());
        if (len < 17) {
            outBuf.writeZero(17 - len);
        }
        outBuf.writeByte(protoMsg.version);
        outBuf.writeByte(1);
        outBuf.writeShort(dataLen + 6);
        ProtoUtil.writeCollTime(outBuf, protoMsg.collTime);
        if (dataLen > 0) {
            outBuf.writeBytes(protoMsg.dataBuf);
        }
        list.add(outBuf);
    }

    @Override
    public Wqg6Msg decode(ChannelHandlerContext ctx, ByteBuf out, Class<? extends TcpProtoMsg> msgClass) {
        Wqg6Msg protoMsg = new Wqg6Msg();
        protoMsg.id = out.readUnsignedByte();
        protoMsg.key = ProtoUtil.readString(out, 17);
        protoMsg.version = out.readUnsignedByte();
        protoMsg.cryptType = out.readByte();
        out.skipBytes(2);
        protoMsg.dataBuf = out;
        return protoMsg;
    }
}

