/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_809;

import com.dfssi.access.common.codec.PackDecoder;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.xy_809.Xy809Constant;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;

public class Xy809Decoder
extends PackDecoder {
    private boolean _5a = false;
    private boolean _5e = false;
    private int crc = 0;

    @Override
    public void decode(ByteBuf in, List<Object> list) throws CodecException {
        while (in.isReadable()) {
            byte b = in.readByte();
            if (this.hasHead) {
                if (b == 93) {
                    this.hasHead = false;
                    int packCrc = this.out.getUnsignedShort(this.out.writerIndex() - 2);
                    packCrc = Xy809Constant.calcCRC(packCrc, this.out.getByte(this.out.writerIndex() - 2));
                    if ((packCrc = Xy809Constant.calcCRC(packCrc, this.out.getByte(this.out.writerIndex() - 1))) == this.crc) {
                        this.out.writerIndex(this.out.writerIndex() - 2);
                        list.add(this.out);
                        continue;
                    }
                    String outStr = ProtoUtil.wholeStrWithSpace(this.out);
                    this.out.release();
                    throw new CodecException(ErrorCode.CRC_CHECK_FAILURE, "CRC\u6821\u9a8c\u5931\u8d25\uff1a" + outStr);
                }
                if (b == 90) {
                    this._5a = true;
                    continue;
                }
                if (b == 94) {
                    this._5e = true;
                    continue;
                }
                if (b == 1) {
                    if (this._5a) {
                        b = 91;
                        this._5a = false;
                    } else if (this._5e) {
                        b = 93;
                        this._5e = false;
                    }
                } else if (b == 2) {
                    if (this._5a) {
                        b = 90;
                        this._5a = false;
                    } else if (this._5e) {
                        b = 94;
                        this._5e = false;
                    }
                }
                this.out.writeByte((int)b);
                this.crc = Xy809Constant.calcCRC(this.crc, b);
                continue;
            }
            if (b != 91) continue;
            this.hasHead = true;
            this._5a = false;
            this._5e = false;
            this.crc = 65535;
            this.out = Unpooled.buffer((int)32);
        }
    }
}

