/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.xy_809;

import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.exception.MsgProcessException;
import com.dfssi.access.common.listener.ConnAuthListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.xy_809.Xy809Msg;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class Xy809Connection
extends TcpConnection {
    private static final AtomicIntegerFieldUpdater<Xy809Connection> snUpdater = AtomicIntegerFieldUpdater.newUpdater(Xy809Connection.class, "downSn");
    private volatile int downSn;
    private final Random random = new Random();
    private volatile byte[] version;
    private volatile Long m1;
    private volatile Long ia1;
    private volatile Long ic1;

    public Xy809Connection(Channel channel, boolean server, ConnAuthListener authListener) {
        super(channel, server, authListener);
    }

    @Override
    public void initUpMsg(TcpProtoMsg upMsg) {
        this.version = ((Xy809Msg)upMsg).version;
    }

    public void setEncryptParam(long m1, long ia1, long ic1) {
        this.m1 = m1;
        this.ia1 = ia1;
        this.ic1 = ic1;
    }

    @Override
    public void fillUpMsg(TcpProtoMsg upMsg) throws MsgProcessException {
        Xy809Msg msg = (Xy809Msg)upMsg;
        if (!msg.encrypt) {
            return;
        }
        if (this.m1 == null) {
            throw new MsgProcessException(ErrorCode.DECRYPT_ERROR, "\u672a\u8bbe\u7f6e m1, ia1, ic1\uff0c\u65e0\u6cd5\u89e3\u5bc6");
        }
        this.encrypt(msg.decryptKey, msg.dataBuf);
    }

    @Override
    public void fillDownMsg(TcpProtoMsg downMsg) {
        Xy809Msg msg = (Xy809Msg)downMsg;
        msg.sn = snUpdater.getAndIncrement(this);
        msg.version = this.version;
        boolean bl = msg.encrypt = this.m1 != null;
        if (msg.encrypt) {
            while (msg.decryptKey == null || msg.decryptKey == 0L) {
                msg.decryptKey = this.random.nextInt();
            }
            this.encrypt(msg.decryptKey, msg.dataBuf);
        }
    }

    private void encrypt(long key, ByteBuf in) {
        if (in == null || !in.isReadable()) {
            return;
        }
        if (key == 0L) {
            key = 1L;
        }
        int writerIndex = in.writerIndex();
        for (int i = in.readerIndex(); i < writerIndex; ++i) {
            key = this.ia1 * (key % this.m1) + this.ic1;
            byte v = (byte)((key &= 0xFFFFFFFFL) >> 20 & 0xFFL);
            in.setByte(i, in.getByte(i) ^ v);
        }
    }
}

