/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.tcp;

import com.alibaba.fastjson.JSONObject;
import com.dfssi.access.common.listener.ConnAuthListener;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.Connection;
import com.dfssi.access.common.util.ProtoUtil;
import io.netty.channel.Channel;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.logging.log4j.util.Strings;

public abstract class TcpConnection
extends Connection {
    private static final AtomicIntegerFieldUpdater<TcpConnection> errorCountUpdater = AtomicIntegerFieldUpdater.newUpdater(TcpConnection.class, "errorCount");
    private volatile int errorCount = 0;
    private static final AtomicLongFieldUpdater<TcpConnection> sendCountUpdater = AtomicLongFieldUpdater.newUpdater(TcpConnection.class, "sendCount");
    private volatile long sendCount = 0L;
    private static final AtomicLongFieldUpdater<TcpConnection> recvCountUpdater = AtomicLongFieldUpdater.newUpdater(TcpConnection.class, "recvCount");
    private volatile long recvCount = 0L;
    private final long createTime = System.currentTimeMillis();
    private final boolean server;
    private final ConnAuthListener authListener;
    private volatile boolean auth = false;
    private volatile String authKey;
    private volatile Serializable entity;

    public TcpConnection(Channel channel, boolean server, ConnAuthListener authListener) {
        super(channel);
        this.server = server;
        this.authListener = authListener;
        this.channel.attr(ProtoUtil.CONN_KEY).set((Object)this);
    }

    public abstract void initUpMsg(TcpProtoMsg var1);

    public abstract void fillUpMsg(TcpProtoMsg var1) throws Exception;

    public abstract void fillDownMsg(TcpProtoMsg var1) throws Exception;

    public void authSuccess(String authKey, Serializable entity) {
        if (Strings.isBlank((String)authKey) || entity == null) {
            return;
        }
        this.entity = entity;
        this.authListener.authSuccess(authKey, this);
        this.authKey = authKey;
        this.auth = true;
    }

    public void authFail() {
        this.entity = null;
        this.authListener.authFail(this);
        this.authKey = null;
        this.auth = false;
        this.incErrorCount("\u9274\u6743\u5931\u8d25");
    }

    public void incErrorCount(String errDesc) {
        this.info(errDesc, new Object[0]);
        if (this.authListener.maxErrorCount() > 0 && errorCountUpdater.incrementAndGet(this) == this.authListener.maxErrorCount()) {
            this.close("\u7d2f\u8ba1\u6536\u5230" + this.authListener.maxErrorCount() + "\u6761\u9519\u8bef\u6d88\u606f\uff0c\u8fde\u63a5\u5173\u95ed");
        }
    }

    public void incRecvCount() {
        recvCountUpdater.incrementAndGet(this);
    }

    public void incSendCount() {
        sendCountUpdater.incrementAndGet(this);
    }

    public boolean notRecvMsg() {
        return recvCountUpdater.get(this) == 0L;
    }

    @Override
    public String desc() {
        if (this.auth) {
            return "[" + this.remoteHost + ":" + this.remotePort + "][" + this.authKey + "] ";
        }
        return "[" + this.remoteHost + ":" + this.remotePort + "] ";
    }

    public JSONObject toJson(DateTimeFormatter formatter) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)(this.remoteHost + ":" + this.remotePort));
        jsonObject.put("auth", (Object)this.isAuth());
        jsonObject.put("commandKey", (Object)(this.authKey == null ? "" : this.authKey));
        jsonObject.put("createTime", (Object)formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.createTime), ZoneId.systemDefault())));
        jsonObject.put("sendCount", (Object)sendCountUpdater.get(this));
        jsonObject.put("recvCount", (Object)recvCountUpdater.get(this));
        return jsonObject;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public Serializable getEntity() {
        return this.entity;
    }
}

