/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.remote;

import com.dfssi.access.common.annotation.CommandCall;
import com.dfssi.access.common.annotation.RemoteAsync;
import com.dfssi.access.common.annotation.RemoteConn;
import com.dfssi.access.common.annotation.RemoteConnParam;
import com.dfssi.access.common.annotation.RemoteParam;
import com.dfssi.access.common.exception.NoConnException;
import com.dfssi.access.common.exception.RemoteException;
import com.dfssi.access.common.master.MasterConnection;
import com.dfssi.access.common.master.MasterServerHandler;
import com.dfssi.access.common.message.MethodInvokeMeta;
import com.dfssi.access.common.tcp.TcpCommand;
import com.dfssi.access.common.util.Command;
import com.dfssi.access.common.util.ConnFind;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class ProxyMasterBean
extends AbstractFactoryBean<Object>
implements InvocationHandler {
    private final Class<?> interfaces;
    private final boolean commandCall;
    @Autowired
    private MasterServerHandler masterServerHandler;
    @Autowired(required=false)
    private ConnFind connFind;

    public ProxyMasterBean(Class<?> clazz) {
        this.commandCall = clazz.isAnnotationPresent(CommandCall.class);
        if (clazz.isAnnotationPresent(RemoteConn.class)) {
            RemoteConn remoteCall = clazz.getAnnotation(RemoteConn.class);
            Assert.hasLength((String)remoteCall.value(), (String)(clazz + "\u7684@RemoteConn\u6ce8\u89e3\u503c\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        for (Method method : clazz.getDeclaredMethods()) {
            int[] clientParam;
            if (this.commandCall) {
                Assert.isTrue((!method.isAnnotationPresent(RemoteAsync.class) ? 1 : 0) != 0, (String)(clazz + ":" + method.getName() + "\u4e0d\u80fd\u4f7f\u7528@RemoteAsync\u6ce8\u89e3"));
                Object[] types = method.getParameterTypes();
                Assert.notEmpty((Object[])types, (String)(clazz + ":" + method.getName() + "\u6ca1\u6709\u53c2\u6570"));
                if (types.length != 1) {
                    throw new IllegalArgumentException(clazz + ":" + method.getName() + ":\u53c2\u6570\u4e2a\u6570\u5927\u4e8e1");
                }
                Assert.isAssignable(TcpCommand.class, (Class)types[0], (String)(clazz + ":" + method.getName() + ":\u53c2\u6570" + types[0] + " is not assignable to " + TcpCommand.class));
            }
            if (method.isAnnotationPresent(RemoteConn.class)) {
                RemoteConn remoteCall = method.getAnnotation(RemoteConn.class);
                Assert.hasLength((String)remoteCall.value(), (String)(clazz + ":" + method.getName() + "\u7684@RemoteConn\u6ce8\u89e3\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if ((clientParam = this.getMethodClientParamIndex(method)) != null) {
                Assert.isAssignable(String.class, method.getParameterTypes()[clientParam[0]], (String)(clazz + ":" + method.getName() + ":@RemoteConnParam\u6ce8\u89e3\u7684\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662fString"));
            }
            if (!method.isAnnotationPresent(RemoteAsync.class)) continue;
            Assert.isTrue((Void.class == method.getReturnType() ? 1 : 0) != 0, (String)(clazz + ":" + method.getName() + "\u7684\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u662fVoid"));
            Assert.isTrue((!method.isAnnotationPresent(RemoteParam.class) ? 1 : 0) != 0, (String)(clazz + ":" + method.getName() + "\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528@RemoteAsync\u4e0e@RemoteParam\u6ce8\u89e3"));
        }
        this.interfaces = clazz;
    }

    public Class<?> getObjectType() {
        return this.interfaces;
    }

    protected Object createInstance() {
        return Proxy.newProxyInstance(this.interfaces.getClassLoader(), new Class[]{this.interfaces}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.commandCall && args[0] == null) {
            throw new RemoteException("TcpCommand\u4e3a\u7a7a\u503c");
        }
        String commandKey = this.getCommandKey(args);
        if (Strings.isNotBlank((String)commandKey)) {
            return this.remoteCall(method, args, this.getClientName(commandKey));
        }
        int[] clientParam = this.getMethodClientParamIndex(method);
        if (clientParam != null) {
            String clientInfo = (String)args[clientParam[0]];
            if (Strings.isBlank((String)clientInfo)) {
                throw new RemoteException("@RemoteConnParam\u6ce8\u89e3\u7684\u53c2\u6570\u503c\u4e3a\u7a7a");
            }
            if (clientParam[1] == 0) {
                return this.remoteCall(method, args, clientInfo);
            }
            if (this.connFind != null) {
                return this.remoteCall(method, args, this.getClientName(clientInfo));
            }
            throw new RemoteException("\u5728IOC\u5bb9\u5668\u4e2d\u6ca1\u6709" + ConnFind.class + "\u7684\u5b9e\u73b0\u7c7b");
        }
        if (method.isAnnotationPresent(RemoteConn.class)) {
            RemoteConn remoteCall = method.getAnnotation(RemoteConn.class);
            return this.remoteCall(method, args, remoteCall.value());
        }
        if (this.interfaces.isAnnotationPresent(RemoteConn.class)) {
            RemoteConn remoteCall = this.interfaces.getAnnotation(RemoteConn.class);
            return this.remoteCall(method, args, remoteCall.value());
        }
        throw new RemoteException("\u65e0\u6cd5\u83b7\u53d6\u5230connName\uff0c\u6d88\u606f\u65e0\u6cd5\u53d1\u9001");
    }

    private String getCommandKey(Object[] args) {
        if (this.connFind == null || args == null || args.length == 0) {
            return null;
        }
        for (Object arg : args) {
            if (!(arg instanceof Command)) continue;
            return ((Command)arg).commandKey();
        }
        return null;
    }

    private String getClientName(String commandKey) throws RemoteException {
        try {
            String clientName = this.connFind.getConnName(commandKey);
            if (Strings.isBlank((String)clientName)) {
                throw new RemoteException("\u6839\u636ecommandKey[" + commandKey + "]\u627e\u5230\u7684connName\u503c\u4e3a\u7a7a");
            }
            return clientName;
        }
        catch (NoConnException e) {
            throw new RemoteException("[" + commandKey + "]\u6ca1\u6709\u8fd9\u4e2a\u8fde\u63a5");
        }
    }

    private int[] getMethodClientParamIndex(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof RemoteConnParam)) continue;
                return new int[]{i, ((RemoteConnParam)annotation).commandKey() ? 1 : 0};
            }
        }
        return null;
    }

    private Object remoteCall(Method method, Object[] args, String clientName) throws Throwable {
        MasterConnection conn = this.masterServerHandler.getConnMap().get(clientName);
        if (conn == null) {
            throw new RemoteException("[" + clientName + "]\u6ca1\u6709\u8fd9\u4e2a\u8fde\u63a5");
        }
        return this.masterServerHandler.channelWrite(new MethodInvokeMeta(this.interfaces, method, args), conn.channel);
    }
}

