/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.monitor;

import com.alibaba.fastjson.JSON;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class MonitorResponse
extends DefaultHttpResponse {
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_DATA = "data";
    private static final String KEY_MESSAGE = "message";
    private final ChunkedStream chunkedStream;

    public static HashMap<String, Object> genSuccessMap(Object data) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>();
        responseMap.put(KEY_SUCCESS, true);
        responseMap.put(KEY_CODE, 200);
        responseMap.put(KEY_DATA, data);
        return responseMap;
    }

    public static MonitorResponse genSuccessResponse(Object data) {
        return MonitorResponse.genOkResponse(MonitorResponse.genSuccessMap(data));
    }

    public static MonitorResponse genFailResponse(String message) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>();
        responseMap.put(KEY_SUCCESS, false);
        responseMap.put(KEY_CODE, 0);
        responseMap.put(KEY_MESSAGE, message);
        return MonitorResponse.genOkResponse(responseMap);
    }

    private static MonitorResponse genOkResponse(HashMap<String, Object> map) {
        return new MonitorResponse(HttpResponseStatus.OK, "application/json; charset=UTF-8", JSON.toJSONString(map));
    }

    public static MonitorResponse genNotFoundResponse(String uri) {
        return new MonitorResponse(HttpResponseStatus.OK, "text/html; charset=UTF-8", uri + " not found");
    }

    public MonitorResponse(HttpResponseStatus status, String contentType, byte[] bytes) {
        super(HttpVersion.HTTP_1_1, status);
        this.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        this.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        this.chunkedStream = new ChunkedStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public MonitorResponse(HttpResponseStatus status, String contentType, String content) {
        this(status, contentType, content.getBytes(CharsetUtil.UTF_8));
    }

    public void send(ChannelHandlerContext ctx) {
        ctx.write((Object)this);
        ctx.writeAndFlush((Object)this.chunkedStream).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

