/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.monitor;

import com.dfssi.access.common.monitor.MonitorResponse;
import com.dfssi.access.common.monitor.MonitorServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.util.StreamUtils;

@ChannelHandler.Sharable
public class MonitorHttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(MonitorHttpHandler.class);
    private final EventLoopGroup eventLoopGroup;
    private final int monitorPort;
    private final MonitorServer monitorServer;
    private volatile Channel serverChannel;

    public void run(String ... args) {
        NioEventLoopGroup bossThreadPool = new NioEventLoopGroup(1);
        this.serverChannel = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossThreadPool, this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new HttpResponseEncoder()}).addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(new ChannelHandler[]{MonitorHttpHandler.this});
            }
        }).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).bind(this.monitorPort).syncUninterruptibly().channel();
        log.info("MonitorServer[{}]\u5df2\u542f\u52a8", (Object)this.monitorPort);
        this.serverChannel.closeFuture().addListener(arg_0 -> this.lambda$run$11((EventLoopGroup)bossThreadPool, arg_0));
    }

    @PreDestroy
    public void stop() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel = null;
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String uri = request.uri();
        if (!uri.startsWith("/monitor")) {
            return;
        }
        if (Strings.isEmpty((CharSequence)(uri = uri.replace("/monitor", ""))) || uri.equals("/")) {
            uri = "/server.html";
        }
        MonitorResponse response = null;
        if (uri.endsWith(".html")) {
            response = this.getResponse(uri, "text/html; charset=UTF-8");
        } else if (uri.endsWith(".js")) {
            response = this.getResponse(uri, "application/x-javascript");
        } else if (uri.endsWith(".css")) {
            response = this.getResponse(uri, "text/css; charset=UTF-8");
        } else if (uri.startsWith("/aspectInfo")) {
            response = MonitorResponse.genSuccessResponse(this.monitorServer.getAspectInfo(null));
        } else if (uri.startsWith("/connInfo")) {
            response = MonitorResponse.genSuccessResponse(this.monitorServer.getConnInfo(null));
        } else if (uri.startsWith("/authInfo")) {
            QueryStringDecoder decoder = new QueryStringDecoder(uri);
            for (Map.Entry entry : decoder.parameters().entrySet()) {
                if (!((String)entry.getKey()).equals("commandKey")) continue;
                response = MonitorResponse.genSuccessResponse(this.monitorServer.getAuthInfo(null, (String)((List)entry.getValue()).get(0)));
                break;
            }
        } else {
            response = MonitorResponse.genNotFoundResponse(uri);
        }
        if (response != null) {
            response.send(ctx);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        MonitorResponse response = new MonitorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", "\u670d\u52a1\u53d1\u751f\u5f02\u5e38");
        response.send(ctx);
    }

    private MonitorResponse getResponse(String path, String contentType) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/monitor" + path);
        if (inputStream == null) {
            return MonitorResponse.genNotFoundResponse(path);
        }
        MonitorResponse monitorResponse = new MonitorResponse(HttpResponseStatus.OK, contentType, StreamUtils.copyToByteArray((InputStream)inputStream));
        inputStream.close();
        return monitorResponse;
    }

    public MonitorHttpHandler(EventLoopGroup eventLoopGroup, int monitorPort, MonitorServer monitorServer) {
        this.eventLoopGroup = eventLoopGroup;
        this.monitorPort = monitorPort;
        this.monitorServer = monitorServer;
    }

    private /* synthetic */ void lambda$run$11(EventLoopGroup eventLoopGroup, Future future) throws Exception {
        eventLoopGroup.shutdownGracefully();
        log.info("MonitorServer[{}]\u5df2\u7ecf\u88ab\u5173\u95ed", (Object)this.monitorPort);
    }
}

