/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.monitor;

import com.dfssi.access.common.master.MasterServerHandler;
import com.dfssi.access.common.monitor.MonitorResponse;
import com.dfssi.access.common.monitor.MonitorServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnWebApplication
@RestController
@RequestMapping(value={"/monitor"})
public class MonitorController {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    @Autowired
    private MasterServerHandler masterServerHandler;
    @Autowired
    private MonitorServer monitorServer;

    @GetMapping(value={"/", "/conn.html"})
    public void getConnHtml(HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        InputStream inputStream = this.getClass().getResourceAsStream("/monitor/conn.html");
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        inputStream.close();
    }

    @GetMapping(value={"/server.html"})
    public void getServerHtml(HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        InputStream inputStream = this.getClass().getResourceAsStream("/monitor/server.html");
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        inputStream.close();
    }

    @GetMapping(value={"/connServer"})
    public Object getConnAll() {
        return MonitorResponse.genSuccessMap(this.masterServerHandler.getConnMap().values().stream().map(connection -> connection.toJson(this.formatter)).collect(Collectors.toList()));
    }

    @GetMapping(value={"/aspectInfo"})
    public Object getAspectInfo(@RequestParam String connName) throws Exception {
        return MonitorResponse.genSuccessMap(this.monitorServer.getAspectInfo(connName));
    }

    @GetMapping(value={"/connInfo"})
    public Object getConnInfo(@RequestParam String connName) {
        return MonitorResponse.genSuccessMap(this.monitorServer.getConnInfo(connName));
    }

    @GetMapping(value={"/authInfo"})
    public Object getAuthInfo(@RequestParam String connName, @RequestParam String commandKey) {
        return MonitorResponse.genSuccessMap(this.monitorServer.getAuthInfo(connName, commandKey));
    }
}

