/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.master;

import com.dfssi.access.common.codec.MarshallCodec;
import com.dfssi.access.common.master.MasterProperties;
import com.dfssi.access.common.master.MasterServerHandler;
import com.dfssi.access.common.util.Connection;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;

public class MasterServerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MasterServerRunner.class);
    private final MasterProperties properties;
    private final MasterServerHandler masterServerHandler;
    private Channel serverChannel;

    public void run(String ... args) throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap();
        NioEventLoopGroup bossThreadPool = new NioEventLoopGroup(1);
        NioEventLoopGroup ioThreadPool = new NioEventLoopGroup(this.properties.getThreadCount());
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossThreadPool, (EventLoopGroup)ioThreadPool).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)2048)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{MarshallCodec.buildDecoder(), MarshallCodec.buildEncoder(), new IdleStateHandler((long)(MasterServerRunner.this.properties.getIdleTimeout() * 2), 0L, 0L, TimeUnit.SECONDS), MasterServerRunner.this.masterServerHandler});
            }
        }).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.serverChannel = bootstrap.bind(this.properties.getPort()).sync().channel();
        log.info("NettyServer\u5df2\u542f\u52a8,\u7aef\u53e3\u53f7:{}", (Object)this.properties.getPort());
        this.serverChannel.closeFuture().addListener(arg_0 -> MasterServerRunner.lambda$run$14((EventLoopGroup)ioThreadPool, (EventLoopGroup)bossThreadPool, arg_0));
    }

    public void destroy() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel = null;
        }
        for (Connection connection : this.masterServerHandler.getConnMap().values()) {
            connection.close("Master\u88ab\u5173\u95ed\u4e86");
        }
    }

    public MasterServerRunner(MasterProperties properties, MasterServerHandler masterServerHandler) {
        this.properties = properties;
        this.masterServerHandler = masterServerHandler;
    }

    private static /* synthetic */ void lambda$run$14(EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2, Future future) throws Exception {
        eventLoopGroup.shutdownGracefully();
        eventLoopGroup2.shutdownGracefully();
    }
}

