/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.codec;

import com.dfssi.access.common.codec.MethodAdapter;
import com.dfssi.access.common.exception.CodecException;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.exception.MsgProcessException;
import com.dfssi.access.common.listener.MsgErrorListener;
import com.dfssi.access.common.listener.MsgHandlerListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpListenerMsg;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.tcp.TcpReplyMsg;
import com.dfssi.access.common.util.XyMsg;
import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public class MsgHandlerAdapter
implements MsgHandlerListener {
    @Autowired
    private MethodAdapter methodAdapter;
    @Autowired(required=false)
    private MsgErrorListener msgErrorListener;
    private final Set<TcpListenerMsg> listenerMses = Sets.newConcurrentHashSet();

    @Override
    public void handlerReceiveMsg(ChannelHandlerContext ctx, TcpConnection connection, TcpProtoMsg upMsg, boolean checkAuth) {
        Object result;
        block12: {
            connection.incRecvCount();
            result = null;
            try {
                result = this.methodAdapter.processUpMsg(connection, upMsg, checkAuth);
            }
            catch (MsgProcessException e) {
                connection.info(e.getMessage(), new Object[0]);
                if (this.msgErrorListener != null) {
                    result = this.msgErrorListener.upMsgProcessError(connection, upMsg, e.code);
                }
            }
            catch (Exception e) {
                Throwable throwable = e.getCause() != null ? e.getCause() : e;
                connection.error("msgKey[" + upMsg.msgKey() + "]\u4e0a\u884c\u6d88\u606f" + upMsg.getId() + "\u5904\u7406\u5931\u8d25\uff0c\u539f\u59cb\u62a5\u6587:" + upMsg.getOriginal(true), throwable);
                if (this.msgErrorListener == null) break block12;
                result = this.msgErrorListener.upMsgProcessError(connection, upMsg, throwable instanceof CodecException ? ((CodecException)throwable).code : ErrorCode.OTHER_ERROR);
            }
        }
        if (result == null) {
            return;
        }
        if (result instanceof List) {
            ChannelFuture future = null;
            for (Object o : (List)result) {
                if (o == null) continue;
                if (o instanceof TcpReplyMsg) {
                    this.handlerReplyMsg(connection, upMsg, (TcpReplyMsg)o);
                    continue;
                }
                if (o instanceof ChannelFutureListener) {
                    if (future == null) continue;
                    future.addListener((GenericFutureListener)((ChannelFutureListener)o));
                    continue;
                }
                future = ctx.writeAndFlush(o instanceof XyMsg ? o : XyMsg.create(upMsg.key, o));
            }
        } else if (result instanceof TcpReplyMsg) {
            this.handlerReplyMsg(connection, upMsg, (TcpReplyMsg)result);
        } else {
            ctx.writeAndFlush(result instanceof XyMsg ? result : XyMsg.create(upMsg.key, result));
        }
    }

    @Override
    public boolean handlerReplyMsg(TcpConnection connection, TcpProtoMsg upMsg, TcpReplyMsg replyMsg) {
        String replyKey = replyMsg.replyKey(upMsg);
        if (Strings.isBlank((String)replyKey)) {
            return false;
        }
        connection.debug("\u56de\u590d\u6d88\u606f[{}]\u7684\u7b54\u590dkey=[{}]", replyMsg.getClass().getSimpleName(), replyKey);
        Iterator<TcpListenerMsg> iterator = this.listenerMses.iterator();
        long currentTimeMillis = System.currentTimeMillis();
        while (iterator.hasNext()) {
            TcpListenerMsg listenerMsg = iterator.next();
            if (currentTimeMillis - listenerMsg.getSendTime() > (long)listenerMsg.maxLifeTime()) {
                iterator.remove();
                continue;
            }
            int i = listenerMsg.indexOfKey(connection.channel.id() + "_" + replyKey);
            if (i < 0) continue;
            if (i == 0 || replyMsg.replyOver()) {
                listenerMsg.listenerOver(replyMsg);
                iterator.remove();
                connection.debug("\u6307\u4ee4[{}]\u5df2\u6536\u5230\u56de\u590d\u6d88\u606f", listenerMsg.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    @Override
    public void sendListenerMsg(Channel channel, TcpListenerMsg tcpListenerMsg) {
        channel.eventLoop().execute(() -> channel.writeAndFlush((Object)tcpListenerMsg).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                if (tcpListenerMsg.needListener()) {
                    this.listenerMses.add(tcpListenerMsg);
                } else {
                    tcpListenerMsg.listenerOver(null);
                }
            } else {
                tcpListenerMsg.listenerOver(f.cause());
            }
            if (tcpListenerMsg.getLife() != null) {
                tcpListenerMsg.getLife().sendComplete(f.isSuccess());
            }
        })));
    }
}

