/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.codec;

import com.dfssi.access.common.annotation.DownEntity;
import com.dfssi.access.common.annotation.DownMsg;
import com.dfssi.access.common.annotation.MsgProcess;
import com.dfssi.access.common.annotation.UpMsg;
import com.dfssi.access.common.codec.MethodInvoker;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.exception.MsgProcessException;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpListenerMsg;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.util.XyMsg;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class MethodAdapter
implements ApplicationListener<ApplicationStartedEvent> {
    private final Map<String, MethodInvoker> methodInvokers = Maps.newHashMap();

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        ConfigurableApplicationContext applicationContext = applicationStartedEvent.getApplicationContext();
        try {
            for (Object value : applicationContext.getBeansWithAnnotation(MsgProcess.class).values()) {
                this.addMethodInvoker(value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            applicationContext.close();
        }
    }

    private void addMethodInvoker(Object bean) throws IllegalAccessException {
        MsgProcess msgProcess = bean.getClass().getAnnotation(MsgProcess.class);
        Method[] declaredMethods = bean.getClass().getDeclaredMethods();
        if (declaredMethods.length == 0) {
            return;
        }
        for (Method method : declaredMethods) {
            if (method.getParameterCount() == 0) continue;
            if (method.isAnnotationPresent(UpMsg.class)) {
                UpMsg upMsg = method.getAnnotation(UpMsg.class);
                String msgKey = upMsg.receiveId() + "_" + msgProcess.server();
                if (this.methodInvokers.containsKey(msgKey)) {
                    MethodInvoker invoker = this.methodInvokers.get(msgKey);
                    if (invoker.isUnique() == msgProcess.methodUnique()) {
                        throw new IllegalAccessException("msgId:" + ProtoUtil.formatId(upMsg.receiveId()) + "\u88ab\u91cd\u590d\u6ce8\u89e3@UpMsg->{" + bean.getClass().getName() + ":" + method.getName() + "}+{" + invoker.getBean().getClass().getName() + ":" + invoker.getMethod().getName() + "}");
                    }
                    if (invoker.isUnique() && !msgProcess.methodUnique()) continue;
                }
                this.methodInvokers.put(msgKey, new MethodInvoker.Up(bean, method, method.getParameterTypes(), msgProcess.methodUnique(), upMsg));
                continue;
            }
            if (!method.isAnnotationPresent(DownMsg.class)) continue;
            if (method.getReturnType() != ByteBuf.class && !TcpProtoMsg.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalAccessException("\u4e0b\u884c\u6d88\u606f\u5904\u7406\u65b9\u6cd5{" + bean.getClass().getName() + ":" + method.getName() + "}\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u662f{ByteBuf}\u6216{TcpProtoMsg\u5b50\u7c7b}");
            }
            Class<?>[] params = method.getParameterTypes();
            int index = -1;
            if (params.length > 1) {
                Annotation[][] annotations = method.getParameterAnnotations();
                if (annotations.length > 0) {
                    block1: for (int i = 0; i < annotations.length; ++i) {
                        for (Annotation annotation : annotations[i]) {
                            if (!(annotation instanceof DownEntity)) continue;
                            if (index >= 0) {
                                throw new IllegalAccessException("\u4e0b\u884c\u6d88\u606f\u5904\u7406\u65b9\u6cd5{" + bean.getClass().getName() + ":" + method.getName() + "}\u53c2\u6570\u4e0a\u53ea\u80fd\u6709\u4e00\u4e2a@DownEntity\u6ce8\u89e3");
                            }
                            index = i;
                            continue block1;
                        }
                    }
                }
            } else {
                index = 0;
            }
            if (index == -1) {
                throw new IllegalAccessException("\u4e0b\u884c\u6d88\u606f\u5904\u7406\u65b9\u6cd5{" + bean.getClass().getName() + ":" + method.getName() + "}\u53c2\u6570\u4e0a\u6ca1\u6709@DownEntity\u6ce8\u89e3");
            }
            if (TcpConnection.class.isAssignableFrom(params[index]) || Channel.class == params[index] || EventLoop.class == params[index]) {
                throw new IllegalAccessException("\u4e0b\u884c\u6d88\u606f\u5904\u7406\u65b9\u6cd5{" + bean.getClass().getName() + ":" + method.getName() + "}@DownEntity\u6ce8\u89e3\u7684\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u662f" + params[index].getName());
            }
            String msgKey = params[index].getName() + "_" + msgProcess.server();
            if (this.methodInvokers.containsKey(msgKey)) {
                MethodInvoker invoker = this.methodInvokers.get(msgKey);
                if (invoker.isUnique() == msgProcess.methodUnique()) {
                    throw new IllegalAccessException("\u4e0b\u884c\u6d88\u606f\u5b9e\u4f53\u7c7b{" + params[index].getName() + "}\u88ab\u91cd\u590d\u4f7f\u7528->{" + bean.getClass().getName() + ":" + method.getName() + "}+{" + invoker.getBean().getClass().getName() + ":" + invoker.getMethod().getName() + "}");
                }
                if (invoker.isUnique() && !msgProcess.methodUnique()) continue;
            }
            this.methodInvokers.put(msgKey, new MethodInvoker.Down(bean, method, params, msgProcess.methodUnique(), method.getAnnotation(DownMsg.class)));
        }
    }

    public MethodInvoker getUpMethodInvoker(TcpConnection connection, int id) {
        return this.methodInvokers.get(id + "_" + connection.isServer());
    }

    public Object processUpMsg(TcpConnection connection, TcpProtoMsg upMsg, boolean checkAuth) throws Exception {
        MethodInvoker.Up msgInvoker = (MethodInvoker.Up)this.getUpMethodInvoker(connection, upMsg.id);
        if (msgInvoker == null) {
            throw new MsgProcessException(ErrorCode.NO_HANDLER, "\u4e0a\u884c\u6d88\u606f" + upMsg.getId() + "\u6ca1\u6709\u5904\u7406\u65b9\u6cd5");
        }
        if (checkAuth && msgInvoker.getUpMsg().needAuth() && !connection.isAuth()) {
            throw new MsgProcessException(ErrorCode.NO_AUTH, "msgKey[" + upMsg.msgKey() + "]\u4e0a\u884c\u6d88\u606f" + upMsg.getId() + "\u6ca1\u6709\u9274\u6743");
        }
        connection.fillUpMsg(upMsg);
        return msgInvoker.invoke(connection, upMsg);
    }

    public TcpProtoMsg processDownMsg(TcpConnection connection, XyMsg xyMsg, Class<? extends TcpProtoMsg> msgClass) throws Exception {
        TcpProtoMsg downMsg;
        MethodInvoker.Down msgInvoker = (MethodInvoker.Down)this.methodInvokers.get(xyMsg.msgBody().getClass().getName() + "_" + connection.isServer());
        if (msgInvoker == null) {
            throw new MsgProcessException(ErrorCode.NO_HANDLER, "\u4e0b\u884c\u5b9e\u4f53\u7c7b[" + xyMsg.msgBody().getClass().getName() + "]\u6ca1\u6709\u5904\u7406\u65b9\u6cd5");
        }
        Object object = msgInvoker.invoke(connection, xyMsg.msgBody());
        if (object == null) {
            throw new MsgProcessException(ErrorCode.RETURN_NULL, "\u4e0b\u884c\u5b9e\u4f53\u7c7b\u5904\u7406\u65b9\u6cd5[" + msgInvoker.getBean().getClass().getName() + ":" + msgInvoker.getMethod().getName() + "]\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
        DownMsg invokerDownMsg = msgInvoker.getDownMsg();
        if (object instanceof ByteBuf) {
            downMsg = msgClass.newInstance();
            downMsg.dataBuf = (ByteBuf)object;
            downMsg.id = invokerDownMsg.sendId();
            downMsg.key = xyMsg.msgKey();
        } else if (msgClass.isAssignableFrom(object.getClass())) {
            downMsg = (TcpProtoMsg)object;
            if (downMsg.key == null) {
                downMsg.key = xyMsg.msgKey();
            }
            if (downMsg.id == 0) {
                downMsg.id = invokerDownMsg.sendId();
            }
        } else {
            throw new MsgProcessException(ErrorCode.NOT_FIND_AGREEMENT, "TcpProtoMsg\u7c7b\u578b\u9519\u8bef");
        }
        connection.fillDownMsg(downMsg);
        if (xyMsg instanceof TcpListenerMsg) {
            TcpListenerMsg tcpListenerMsg = (TcpListenerMsg)xyMsg;
            if (tcpListenerMsg.getLife() != null) {
                tcpListenerMsg.getLife().sendStart(downMsg);
            }
            for (int replyId : invokerDownMsg.replyId()) {
                String backKey;
                if (replyId == 0 || Strings.isBlank((String)(backKey = tcpListenerMsg.listenerKey(downMsg, replyId)))) continue;
                connection.debug("\u6307\u4ee4[{}]\u7684\u56de\u590dkey=[{}]", tcpListenerMsg.getClass().getSimpleName(), backKey);
                tcpListenerMsg.addListenerKey(connection.channel.id() + "_" + backKey);
            }
        }
        return downMsg;
    }
}

