/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common.client;

import com.dfssi.access.common.AccessProperties;
import com.dfssi.access.common.client.Client;
import com.dfssi.access.common.codec.MethodAdapter;
import com.dfssi.access.common.codec.Pack2MsgCodec;
import com.dfssi.access.common.codec.Pack2PackCodec;
import com.dfssi.access.common.exception.ClientException;
import com.dfssi.access.common.listener.ClientConnListener;
import com.dfssi.access.common.listener.ConnAuthListener;
import com.dfssi.access.common.listener.MsgCodecListener;
import com.dfssi.access.common.listener.MsgHandlerListener;
import com.dfssi.access.common.listener.ProtoMsgListener;
import com.dfssi.access.common.listener.ProtoPackListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpListenerMsg;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.ProtoUtil;
import com.dfssi.access.common.util.XyMsg;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@ChannelHandler.Sharable
public final class ClientConnHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ClientConnHandler.class);
    private final Client client;
    private final MsgHandlerListener msgHandlerListener;
    private final Bootstrap bootstrap;
    private volatile boolean reconnect;
    private volatile Channel channel;

    public ClientConnHandler(ApplicationContext applicationContext, final Client client) throws Exception {
        this.msgHandlerListener = (MsgHandlerListener)applicationContext.getBean(MsgHandlerListener.class);
        this.client = client;
        this.reconnect = client instanceof Client.Keep;
        final Pack2PackCodec pack2PackCodec = new Pack2PackCodec(ProtoUtil.getBean(applicationContext, ProtoPackListener.class), client.agreement().getPackCodecClass().newInstance());
        MsgCodecListener msgCodecListener = client.agreement().getMsgCodecClass().newInstance();
        msgCodecListener.initProperties((AccessProperties)applicationContext.getBean(AccessProperties.class));
        final Pack2MsgCodec pack2MsgCodec = new Pack2MsgCodec(ProtoUtil.getBean(applicationContext, ProtoMsgListener.class), msgCodecListener, (MethodAdapter)applicationContext.getBean(MethodAdapter.class), client.agreement().getTcpMsgClass());
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)applicationContext.getBean(EventLoopGroup.class))).remoteAddress(client.connIp(), client.connPort().intValue()).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                if (client instanceof Client.Keep) {
                    ch.pipeline().addLast(new ChannelHandler[]{pack2PackCodec, pack2MsgCodec, new IdleStateHandler(0L, (long)((Client.Keep)client).idleTimeout(), 0L, TimeUnit.SECONDS), ClientConnHandler.this});
                } else {
                    ch.pipeline().addLast(new ChannelHandler[]{pack2PackCodec, pack2MsgCodec, ClientConnHandler.this});
                }
            }
        });
    }

    public void start() throws ClientException {
        this.connect(true);
    }

    private void connect(boolean first) throws ClientException {
        try {
            ChannelFuture channelFuture = this.bootstrap.connect().syncUninterruptibly();
            if (!channelFuture.isSuccess()) {
                throw new ClientException("[" + this.client.connIp() + ":" + this.client.connPort() + "] " + (first ? "\u8fde" : "\u91cd") + "\u63a5\u5931\u8d25");
            }
            this.channel = channelFuture.channel();
            XyMsg loginEntity = this.client.authInfo();
            final CountDownLatch countDownLatch = loginEntity != null ? new CountDownLatch(1) : null;
            TcpConnection connection = this.client.agreement().getTcpConnClass().getConstructor(Channel.class, Boolean.TYPE, ConnAuthListener.class).newInstance(this.channel, false, new ConnAuthListener(){

                @Override
                public void authSuccess(String authKey, TcpConnection connection) {
                    if (ClientConnHandler.this.client instanceof ClientConnListener) {
                        ((ClientConnListener)((Object)ClientConnHandler.this.client)).beAuthed(connection);
                    }
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }

                @Override
                public void authFail(TcpConnection connection) {
                    ClientConnHandler.this.reconnect = false;
                    connection.close("\u9274\u6743\u5931\u8d25");
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
            });
            log.info("[{}:{}] \u8fde\u63a5\u6210\u529f", (Object)this.client.connIp(), (Object)this.client.connPort());
            if (this.client instanceof ClientConnListener) {
                ((ClientConnListener)((Object)this.client)).beCreated(connection);
            }
            this.channel.closeFuture().addListener(closeFuture -> {
                if (this.client instanceof ClientConnListener) {
                    ((ClientConnListener)((Object)this.client)).beClosed(connection);
                }
                this.channel = null;
                if (this.reconnect) {
                    log.info("[{}:{}] \u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u9a6c\u4e0a\u91cd\u8fde", (Object)this.client.connIp(), (Object)this.client.connPort());
                    this.connect(false);
                } else {
                    log.info("[{}:{}] \u8fde\u63a5\u5df2\u65ad\u5f00", (Object)this.client.connIp(), (Object)this.client.connPort());
                }
            });
            if (loginEntity != null) {
                this.channel.writeAndFlush((Object)loginEntity).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                    if (f.isSuccess()) {
                        countDownLatch.await();
                    } else {
                        log.error("\u9274\u6743\u6d88\u606f\u53d1\u9001\u5931\u8d25", f.cause());
                    }
                }));
            }
            if (loginEntity != null && !connection.isAuth()) {
                throw new ClientException("\u9274\u6743\u5931\u8d25");
            }
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsg(XyMsg xyMsg) throws ClientException {
        if (xyMsg == null) {
            return;
        }
        if (this.channel == null) {
            ClientConnHandler clientConnHandler = this;
            synchronized (clientConnHandler) {
                if (this.channel == null) {
                    this.connect(false);
                }
            }
        }
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush((Object)xyMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendListenerMsg(TcpListenerMsg msg) throws ClientException {
        if (msg == null) {
            return;
        }
        if (this.channel == null) {
            ClientConnHandler clientConnHandler = this;
            synchronized (clientConnHandler) {
                if (this.channel == null) {
                    this.connect(false);
                }
            }
        }
        this.msgHandlerListener.sendListenerMsg(this.channel, msg);
    }

    public void stop() {
        if (this.channel != null) {
            this.reconnect = false;
            this.channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object object) {
        TcpProtoMsg upMsg = (TcpProtoMsg)object;
        try {
            this.msgHandlerListener.handlerReceiveMsg(ctx, (TcpConnection)ctx.channel().attr(ProtoUtil.CONN_KEY).get(), upMsg, false);
        }
        finally {
            upMsg.release();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            ctx.writeAndFlush((Object)((Client.Keep)this.client).heartbeat());
        }
    }
}

