/*
 * Decompiled with CFR 0.152.
 */
package com.dfssi.access.common._808;

import com.dfssi.access.common._808._808Msg;
import com.dfssi.access.common.exception.ErrorCode;
import com.dfssi.access.common.exception.MsgProcessException;
import com.dfssi.access.common.listener.ConnAuthListener;
import com.dfssi.access.common.tcp.TcpConnection;
import com.dfssi.access.common.tcp.TcpProtoMsg;
import com.dfssi.access.common.util.RSAUtil;
import io.netty.channel.Channel;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class _808Connection
extends TcpConnection {
    private static final AtomicIntegerFieldUpdater<_808Connection> snUpdater = AtomicIntegerFieldUpdater.newUpdater(_808Connection.class, "downSn");
    private volatile int downSn;
    private volatile Short version;
    private volatile PublicKey publicKey;
    private volatile PrivateKey privateKey;

    public _808Connection(Channel channel, boolean server, ConnAuthListener authListener) {
        super(channel, server, authListener);
    }

    @Override
    public void initUpMsg(TcpProtoMsg upMsg) {
        this.version = ((_808Msg)upMsg).version;
    }

    @Override
    public void fillUpMsg(TcpProtoMsg upMsg) throws Exception {
        _808Msg msg = (_808Msg)upMsg;
        if (!msg.secrecy) {
            return;
        }
        if (this.privateKey == null) {
            throw new MsgProcessException(ErrorCode.DECRYPT_ERROR, "\u672a\u751f\u6210\u79c1\u94a5\uff0c\u65e0\u6cd5\u89e3\u5bc6");
        }
        RSAUtil.decrypt(msg.dataBuf, this.privateKey);
    }

    @Override
    public void fillDownMsg(TcpProtoMsg downMsg) throws Exception {
        int dataLen;
        _808Msg msg = (_808Msg)downMsg;
        msg.version = this.version;
        int n = dataLen = downMsg.dataBuf == null ? 0 : downMsg.dataBuf.readableBytes();
        if (dataLen > 1023) {
            msg.packCount += (dataLen - 1) / 1023;
            msg.sn = snUpdater.getAndAdd(this, msg.packCount) - (msg.packCount - 1);
        } else {
            msg.sn = snUpdater.getAndIncrement(this);
        }
        msg.sn &= 0xFFFF;
        boolean bl = msg.secrecy = this.publicKey != null;
        if (msg.secrecy) {
            RSAUtil.encrypt(msg.dataBuf, this.publicKey);
        }
    }

    public void setVersion(Short version) {
        this.version = version;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

