/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.DocumentRenderData;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.NumberingRenderPolicy;
import com.deepoove.poi.policy.ParagraphRenderPolicy;
import com.deepoove.poi.policy.TableRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class DocumentRenderPolicy
extends AbstractRenderPolicy<DocumentRenderData> {
    @Override
    protected boolean validate(DocumentRenderData data) {
        return null != data && !data.getContents().isEmpty();
    }

    @Override
    protected void afterRender(RenderContext<DocumentRenderData> context) {
        this.clearPlaceholder(context, true);
    }

    @Override
    public void doRender(RenderContext<DocumentRenderData> context) throws Exception {
        Helper.renderDocument(context.getRun(), context.getData());
    }

    public static class Helper {
        public static void renderDocument(XWPFRun run, DocumentRenderData data) throws Exception {
            List<RenderData> contents = data.getContents();
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            for (RenderData item : contents) {
                XWPFParagraph paragraph = bodyContainer.insertNewParagraph(run);
                XWPFRun createRun = paragraph.createRun();
                StyleUtils.styleParagraph(paragraph, run.getParent());
                StyleUtils.styleRun(createRun, run);
                if (item instanceof ParagraphRenderData) {
                    ParagraphRenderPolicy.Helper.renderParagraph(createRun, (ParagraphRenderData)item);
                    continue;
                }
                if (item instanceof TableRenderData) {
                    TableRenderPolicy.Helper.renderTable(createRun, (TableRenderData)item);
                    BodyContainerFactory.getBodyContainer(createRun).clearPlaceholder(createRun);
                    continue;
                }
                if (!(item instanceof NumberingRenderData)) continue;
                NumberingRenderPolicy.Helper.renderNumbering(createRun, (NumberingRenderData)item);
                BodyContainerFactory.getBodyContainer(createRun).clearPlaceholder(createRun);
            }
        }
    }
}

