/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.Cells;
import com.deepoove.poi.data.MergeCellRule;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.Rows;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.style.BorderStyle;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.util.UnitUtils;
import java.util.Arrays;
import org.apache.poi.xwpf.usermodel.TableRowAlign;

public class Tables {
    private Tables() {
    }

    public static TableBuilder of(RowRenderData ... row) {
        TableBuilder inst = Tables.ofPercentWidth("100%");
        if (null != row) {
            Arrays.stream(row).forEach(inst::addRow);
        }
        return inst;
    }

    public static TableBuilder of(String[][] strings) {
        TableBuilder inst = Tables.ofPercentWidth("100%");
        if (null != strings) {
            Arrays.stream(strings).map(string -> {
                Rows.RowBuilder row = Rows.of();
                Arrays.stream(string).map(text -> Cells.of(text).create()).forEach(row::addCell);
                return row.create();
            }).forEach(inst::addRow);
        }
        return inst;
    }

    public static TableBuilder ofA4Width() {
        return Tables.ofWidth(14.63f);
    }

    public static TableBuilder ofA4NarrowWidth() {
        return Tables.ofWidth(18.45f);
    }

    public static TableBuilder ofA4MediumWidth() {
        return Tables.ofWidth(17.17f);
    }

    public static TableBuilder ofA4ExtendWidth() {
        return Tables.ofWidth(10.83f);
    }

    public static TableBuilder ofWidth(double cm) {
        return Tables.ofWidth(cm, null);
    }

    public static TableBuilder ofWidth(double cm, double[] colWidthsCm) {
        return new TableBuilder().width(cm, colWidthsCm);
    }

    public static TableBuilder ofPercentWidth(String percent) {
        return Tables.ofPercentWidth(percent, null);
    }

    public static TableBuilder ofPercentWidth(String percent, int[] colWidthsPercent) {
        return new TableBuilder().percentWidth(percent, colWidthsPercent);
    }

    public static TableBuilder ofAutoWidth() {
        return new TableBuilder().autoWidth();
    }

    public static TableRenderData create(RowRenderData ... row) {
        return Tables.of(row).create();
    }

    public static class TableBuilder
    implements RenderDataBuilder<TableRenderData> {
        private TableRenderData data = new TableRenderData();

        private TableBuilder() {
            this.border(BorderStyle.DEFAULT);
            this.cellMargin(0.0, 0.19f, 0.0, 0.19f).indentation(0.0);
        }

        public TableBuilder width(double widthCm, double[] colWidthsCm) {
            TableStyle style = this.getTableStyle();
            style.setWidth(UnitUtils.cm2Twips(widthCm) + "");
            if (null != colWidthsCm) {
                int[] colWidths = Arrays.stream(colWidthsCm).mapToInt(UnitUtils::cm2Twips).toArray();
                style.setColWidths(colWidths);
            }
            return this;
        }

        public TableBuilder percentWidth(String percent, int[] colWidthsPercent) {
            int sum;
            TableStyle style = this.getTableStyle();
            if (null != colWidthsPercent && (sum = Arrays.stream(colWidthsPercent).sum()) != 100) {
                throw new IllegalArgumentException("The sum of the percentages must be 100");
            }
            style.setWidth(percent);
            style.setColWidths(colWidthsPercent);
            return this;
        }

        public TableBuilder autoWidth() {
            TableStyle style = this.getTableStyle();
            style.setWidth("auto");
            return this;
        }

        private TableStyle getTableStyle() {
            TableStyle style = this.data.getTableStyle();
            if (null == style) {
                style = new TableStyle();
                this.data.setTableStyle(style);
            }
            return style;
        }

        public TableBuilder left() {
            TableStyle style = this.getTableStyle();
            style.setAlign(TableRowAlign.LEFT);
            return this;
        }

        public TableBuilder center() {
            TableStyle style = this.getTableStyle();
            style.setAlign(TableRowAlign.CENTER);
            return this;
        }

        public TableBuilder right() {
            TableStyle style = this.getTableStyle();
            style.setAlign(TableRowAlign.RIGHT);
            return this;
        }

        public TableBuilder border(BorderStyle border) {
            this.getTableStyle().setLeftBorder(border);
            this.getTableStyle().setRightBorder(border);
            this.getTableStyle().setTopBorder(border);
            this.getTableStyle().setBottomBorder(border);
            this.getTableStyle().setInsideHBorder(border);
            this.getTableStyle().setInsideVBorder(border);
            return this;
        }

        public TableBuilder cellMargin(double topCm, double leftCm, double bottomCm, double rightCm) {
            TableStyle tableStyle = this.getTableStyle();
            tableStyle.setTopCellMargin(UnitUtils.cm2Twips(topCm));
            tableStyle.setLeftCellMargin(UnitUtils.cm2Twips(leftCm));
            tableStyle.setBottomCellMargin(UnitUtils.cm2Twips(bottomCm));
            tableStyle.setRightCellMargin(UnitUtils.cm2Twips(rightCm));
            return this;
        }

        public TableBuilder indentation(double indent) {
            TableStyle tableStyle = this.getTableStyle();
            tableStyle.setIndentation(indent);
            return this;
        }

        public TableBuilder addRow(RowRenderData row) {
            this.data.addRow(row);
            return this;
        }

        public TableBuilder mergeRule(MergeCellRule rule) {
            this.data.setMergeRule(rule);
            return this;
        }

        @Override
        public TableRenderData create() {
            return this.data;
        }
    }
}

