/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class Examples {
    Examples() {
    }

    private static Connection createConnection() throws SQLException {
        String url = "jdbc:databend://localhost:8000";
        return DriverManager.getConnection(url, "databend", "databend");
    }

    public static void main(String[] args2) throws SQLException {
        Connection c = Examples.createConnection();
        System.out.println("-----------------");
        System.out.println("drop all existing test table");
        c.createStatement().execute("drop table if exists test_prepare_statement");
        c.createStatement().execute("create table test_prepare_statement (a int, b string)");
        String sql = "insert into test_prepare_statement values (?,?)";
        Connection conn = Examples.createConnection();
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setInt(1, 1);
            statement.setString(2, "b");
            statement.addBatch();
            int[] result = statement.executeBatch();
            System.out.println(result);
        }
        String updateSQL = "update test_prepare_statement set b = ? where a = ?";
        try (PreparedStatement statement = conn.prepareStatement(updateSQL);){
            statement.setInt(2, 1);
            statement.setString(1, "c");
            int result = statement.executeUpdate();
            System.out.println(result);
        }
        ResultSet r = conn.createStatement().executeQuery("select * from test_prepare_statement");
        while (r.next()) {
            System.out.println(r.getInt(1));
            System.out.println(r.getString(2));
        }
        String replaceIntoSQL = "replace into test_prepare_statement on(a) values (?,?)";
        try (PreparedStatement statement = conn.prepareStatement(replaceIntoSQL);){
            statement.setInt(1, 1);
            statement.setString(2, "d");
            statement.addBatch();
            int[] nArray = statement.executeBatch();
        }
        ResultSet r2 = conn.createStatement().executeQuery("select * from test_prepare_statement");
        while (r2.next()) {
            System.out.println(r2.getInt(1));
            System.out.println(r2.getString(2));
        }
        String deleteSQL = "delete from test_prepare_statement where a = ?";
        try (PreparedStatement statement = conn.prepareStatement(deleteSQL);){
            statement.setInt(1, 1);
            int result = statement.executeUpdate();
            System.out.println(result);
        }
        ResultSet r3 = conn.createStatement().executeQuery("select * from test_prepare_statement");
        while (r3.next()) {
            System.out.println(r3.getInt(1));
            System.out.println(r3.getString(2));
        }
    }
}

